
var Mime_Menu_Edit = {
  menu: null,

  handleEvent: function(event) {
    switch(event.type) {
      case "popupshowing":
        this.Mime_Menu_Pref();
        break;
      case "load":
        this.init();
        break;
      case "unload":
        this.uninit();
    }
  },

  init: function() {
    window.removeEventListener("load", Mime_Menu_Edit, false);
    window.addEventListener("unload", Mime_Menu_Edit, false);
    this.menu = document.getElementById("menu_ToolsPopup") ||
               document.getElementById("taskPopup");
    if (this.menu) {
       this.menu.addEventListener("popupshowing", Mime_Menu_Edit, false);
    }
  },

  uninit: function() {
    window.removeEventListener("unload", Mime_Menu_Edit, false);
    if (this.menu) {
       this.menu.removeEventListener("popupshowing", Mime_Menu_Edit, false);
    }
  },
  
  // This code is used to hide/unhide the Tools MIME Edit menu item
  Mime_Menu_Pref: function() {
  	var mimePref = Components.classes['@mozilla.org/preferences-service;1']
                 .getService(Components.interfaces.nsIPrefBranch);

  	
      
  	if (mimePref.getBoolPref("extensions.rvjmimeedit.hideToolsMenuItem") == true) 
  	{
  	document.getElementById("mime_edit").hidden = true;
  	} 
  	
  	else 
  	{
  	document.getElementById("mime_edit").hidden = false;
  	}

  }
}


window.addEventListener("load", Mime_Menu_Edit, false);
