var goParentFolder = {
  _placesContext: null,

  get placesContext(){
    if (!this._placesContext)
      this._placesContext = document.getElementById('placesContext');
    return this._placesContext;
  },

  handleEvent: function(aEvent){
    switch (aEvent.type) {
      case 'load':
        this.init();
        break;
      case 'unload':
        this.unload();
        break;
      case 'popupshowing':
        this.popupshowing(aEvent);
        break;
    }
  },

  init: function(){
    window.removeEventListener('load', this, false);
    window.addEventListener('unload', this, false);
    this.placesContext.addEventListener('popupshowing', this, true);
  },

  unload: function(){
    this.placesContext.removeEventListener('popupshowing', this, true);
    window.removeEventListener('unload', this, false);
  },

  //hide the menuitem if the context is in the menu-bar and bookmarks-toolbar
  popupshowing: function(aEvent){
    var view = PlacesUIUtils.getViewForNode(document.popupNode);
    //this.debug(view.localName);
    if (!/tree/i.test(view.localName)){
      var node = document.getElementById('placesContext_goParentFolder');
      node.hidden = true;
    }
  },

  openParentFolder: function(){
    var view;
    if (!document.popupNode) {
      view = document.commandDispatcher.focusedElement;
    } else {
      view = PlacesUIUtils.getViewForNode(document.popupNode);    // XULElement
    }
    if (!view || view.getAttribute("type") != "places")
      return;
    var node = view.selectedNode;    // nsINavHistoryResultNode
    var aItemId = node.itemId;
    var aFolderItemId = goParentFolder.getParentFolderByItemId(aItemId);
    if (aFolderItemId)
      goParentFolder.selectFolderByItemId(view, aFolderItemId, aItemId);
  },

  getParentFolderByItemId: function(aItemId){
    var bmsvc = Components.classes["@mozilla.org/browser/nav-bookmarks-service;1"]
                .getService(Components.interfaces.nsINavBookmarksService);
    var parentFolderId = bmsvc.getFolderIdForItem(aItemId);

    return parentFolderId;
  },

  selectItems2: function(view, aIDs) {
    var ids = aIDs; // don't manipulate the caller's array

    // Array of nodes found by findNodes which are to be selected
    var nodes = [];

    // Array of nodes found by findNodes which should be opened
    var nodesToOpen = [];

    // A set of URIs of container-nodes that were previously searched,
    // and thus shouldn't be searched again. This is empty at the initial
    // start of the recursion and gets filled in as the recursion
    // progresses.
    var nodesURIChecked = [];

    /**
     * Recursively search through a node's children for items
     * with the given IDs. When a matching item is found, remove its ID
     * from the IDs array, and add the found node to the nodes dictionary.
     *
     * NOTE: This method will leave open any node that had matching items
     * in its subtree.
     */
    function findNodes(node) {
      var foundOne = false;
      // See if node matches an ID we wanted; add to results.
      // For simple folder queries, check both itemId and the concrete
      // item id.
      var index = ids.indexOf(node.itemId);
      if (index == -1 &&
          node.type == Components.interfaces.nsINavHistoryResultNode.RESULT_TYPE_FOLDER_SHORTCUT) {
        index = ids.indexOf(PlacesUtils.asQuery(node).folderItemId); //xxx Bug 556739 3.7a5pre
      }

      if (index != -1) {
        nodes.push(node);
        foundOne = true;
        ids.splice(index, 1);
      }

      if (ids.length == 0 || !PlacesUtils.nodeIsContainer(node) ||
          nodesURIChecked.indexOf(node.uri) != -1)
        return foundOne;

      nodesURIChecked.push(node.uri);
      PlacesUtils.asContainer(node); //xxx Bug 556739 3.7a6pre

      // Remember the beginning state so that we can re-close
      // this node if we don't find any additional results here.
      var previousOpenness = node.containerOpen;
      node.containerOpen = true;
      for (var child = 0;  child < node.childCount && ids.length > 0;
           child++) {
        var childNode = node.getChild(child);
        var found = findNodes(childNode);
        if (!foundOne)
          foundOne = found;
      }

      // If we didn't find any additional matches in this node's
      // subtree, revert the node to its previous openness.
      if (foundOne)
        nodesToOpen.unshift(node);
      node.containerOpen = previousOpenness;
      return foundOne;
    } //findNodes

/*
    // Null the viewer while looking for nodes
    var result = this.result;
    var oldViewer = result.viewer;
    result.viewer = null;
    findNodes(this.result.root);
    result.viewer = oldViewer;
*/
    // Disable notifications while looking for nodes.
    let result = view.result;
    let didSuppressNotifications = result.suppressNotifications;
    if (!didSuppressNotifications)
      result.suppressNotifications = true
    try {
      findNodes(view.result.root);
    }
    finally {
      if (!didSuppressNotifications)
        result.suppressNotifications = false;
    }

    // For all the nodes we've found, highlight the corresponding
    // index in the tree.
    var resultview = view.view;
    //var resultview = this.getResultView();
    var selection = resultview.selection;
    selection.selectEventsSuppressed = true;
    selection.clearSelection();
    // Open nodes containing found items
    for (var i = 0; i < nodesToOpen.length; i++) {
      nodesToOpen[i].containerOpen = true;
    }
    for (var i = 0; i < nodes.length; i++) {
      if (PlacesUtils.nodeIsContainer(nodes[i]))
        continue;

      var index = resultview.treeIndexForNode(nodes[i]);
      selection.rangedSelect(index, index, true);
    }
    selection.selectEventsSuppressed = false;

  },

  selectFolderByItemId: function(view, aFolderItemId, aItemId){
    //Library
    if (view.getAttribute("id") == "placeContent"){
      view = document.getElementById("placesList");
      //Select a folder node in folder pane
      this.selectItems2(view, [aFolderItemId])
      view.selectItems([aFolderItemId]);
      if (view.currentIndex)
        view.treeBoxObject.ensureRowIsVisible(view.currentIndex);
      //Reselect child node
      setTimeout(function(aItemId, view){
        var aView = view.ownerDocument.getElementById("placeContent");
        aView.selectItems([aItemId]);
        if (aView.currentIndex)
          aView.treeBoxObject.ensureRowIsVisible(aView.currentIndex);
        //Focus folder pane
        //view.focus();
      }, 0, aItemId, view);
      return;
    }

    //Bookmarks Sidebar
    var prefs = Components.classes["@mozilla.org/preferences-service;1"].
               getService(Components.interfaces.nsIPrefBranch);
    var disableSelectFolder = prefs.getBoolPref('extensions.goParentFolder.disableSelectFolder');

    if (!view)
      return;
    view.place = view.place;

    if ('FlatBookmarksOverlay' in window) {
      var sidebarwin = view.ownerDocument.defaultView;
      var searchBox = sidebarwin.document.getElementById("search-box");
      searchBox.value = "";
      searchBox.doCommand();
      sidebarwin.FlatBookmarks._setTreePlace(sidebarwin.FlatBookmarks._makePlaceForFolder(aFolderItemId));
      view.selectItems([aItemId]);
      var tbo = view.treeBoxObject;
      tbo.ensureRowIsVisible(view.currentIndex);
      view.focus();
      return;
    }

    view.findNode = function flatChildNodes(node, aIDs) {
      var ids = aIDs; // don't manipulate the caller's array

      // Array of nodes found by findNodes which are to be selected
      var nodes = [];

      // Array of nodes found by findNodes which should be opened
      var nodesToOpen = [];

      // A set of URIs of container-nodes that were previously searched,
      // and thus shouldn't be searched again. This is empty at the initial
      // start of the recursion and gets filled in as the recursion
      // progresses.
      var nodesURIChecked = [];

      /**
       * Recursively search through a node's children for items
       * with the given IDs. When a matching item is found, remove its ID
       * from the IDs array, and add the found node to the nodes dictionary.
       *
       * NOTE: This method will leave open any node that had matching items
       * in its subtree.
       */
      function findNodes(node) {
        var foundOne = false;
        // See if node matches an ID we wanted; add to results.
        // For simple folder queries, check both itemId and the concrete
        // item id.
        var index = ids.indexOf(node.itemId);
        if (index == -1 &&
            node.type == Components.interfaces.nsINavHistoryResultNode.RESULT_TYPE_FOLDER_SHORTCUT) {
          index = ids.indexOf(PlacesUtils.asQuery(node).folderItemId); //xxx Bug 556739 3.7a5pre
        }

        if (index != -1) {
          nodes.push(node);
          foundOne = true;
          ids.splice(index, 1);
        }

        if (ids.length == 0 || !PlacesUtils.nodeIsContainer(node) ||
            nodesURIChecked.indexOf(node.uri) != -1)
          return foundOne;

        nodesURIChecked.push(node.uri);
        PlacesUtils.asContainer(node); //xxx Bug 556739 3.7a6pre
        // Remember the beginning state so that we can re-close
        // this node if we don't find any additional results here.
        var previousOpenness = node.containerOpen;
        node.containerOpen = true;
        for (var child = 0;  child < node.childCount && ids.length > 0;
             child++) {
          var childNode = node.getChild(child);
          if (/*PlacesUtils.nodeIsLivemarkContainer(childNode) ||*/
              PlacesUtils.nodeIsQuery(childNode) )
            continue;
          var found = findNodes(childNode);
          if (!foundOne)
            foundOne = found;
        }

        // If we didn't find any additional matches in this node's
        // subtree, revert the node to its previous openness.
        if (foundOne)
          nodesToOpen.unshift(node);
        node.containerOpen = previousOpenness;
        return foundOne;
      }//findNodes

/*
      // Null the viewer while looking for nodes
      var result = this.result;
      var oldViewer = result.viewer;
      result.viewer = null;
      findNodes(node);
      result.viewer = oldViewer;
*/
      // Disable notifications while looking for nodes.
      let result = this.result;
      let didSuppressNotifications = result.suppressNotifications;
      if (!didSuppressNotifications)
        result.suppressNotifications = true
      try {
        findNodes(this.result.root);
      }
      finally {
        if (!didSuppressNotifications)
          result.suppressNotifications = false;
      }

      // Open nodes containing found items
      for (var i = 0; i < nodesToOpen.length; i++) {
        nodesToOpen[i].containerOpen = true;
      }
      return nodes;
    };//findNode

    // For all the nodes we've found, highlight the corresponding
    // index in the tree.
    var resultview = view.view;
    //var resultview = view.getResultView();
    var selection = view.view.selection;
    selection.selectEventsSuppressed = true;
    selection.clearSelection();
    var nodes = view.findNode(view.result.root, [aFolderItemId]);
    if (nodes.length > 0){
      var index = resultview.treeIndexForNode(nodes[0]);
      if (!disableSelectFolder) {
        selection.rangedSelect(index, index, true);
      }
      nodes = view.findNode(nodes[0], [aItemId]);
      if (nodes.length > 0){
        index = resultview.treeIndexForNode(nodes[0]);
        selection.rangedSelect(index, index, true);
      }
    }
    selection.selectEventsSuppressed = false;

    var tbo = view.treeBoxObject;
    tbo.ensureRowIsVisible(view.currentIndex);
    view.focus();
    return;
  },

  debug: function(aMsg){
    const Cc = Components.classes;
    const Ci = Components.interfaces;
    Cc["@mozilla.org/consoleservice;1"]
      .getService(Ci.nsIConsoleService)
      .logStringMessage(aMsg);
  }
}

window.addEventListener('load', goParentFolder, false);