// 'MultiRowTabs.uc.js' V02 by BrokenHeart
// based on 'MultiRowTab_LiteforFx48.uc.js' from 'http://space.geocities.yahoo.co.jp/gl/alice0775' (Alice0775)
// Thanks to aborix...

/* ///////////////////////////////////////////////////////////////////////////////////
[13.07.2021 22:45Uhr]
- 'Nur-JavaScript-Version' (CSS wird nicht mehr benötigt)
- Sehr viele funktionale und optische Anpassungen hinzugefügt
[20.02.2020 18:45Uhr]
Fehler in allen CSS-Dateien beseitigt (:thumbup:Dank an diwa fürs melden )
[18.02.2020 13:30Uhr]
- Anpassen des User-JavaSkripts aus (3).
- Skript 'Tabsrunter.uc.js' wurde entfernt, da jetzt bereits in (3) integriert.
[11.12.2019 13:15Uhr]
- Optische Anpassungen an Code (1) und (2).
- Neuen Code hinzugefügt für 'Tabs mit abgerundeten Ecken' (2a).
- Anpassen des User-JavaSkripts zum Verschieben der Tabs (3).
[08.12.2019 17:45Uhr]
- Anpassungen am Code (1) und (2) vorgenommen, um 'Tableiste unten' zu berücksichtigen.
- JavaSkript hinzugefügt, welches die Tableiste nach unten befördert.
[19.08.2022 21:28Uhr]
- Fehler Menüleiste behoben
[23.09.2022 01:58Uhr]
- "Wheel-Event" Problem behoben
[18.10.2022 15:20Uhr]
-Fix: FF106+ -> 'Drag&Drop'
[19.11.2022 09:28Uhr]
-Fix: FF107+ -> 'contain' entfernt
[15.12.2022 07:52Uhr]
-Fix: FF108+ -> Toggle-menubar angepasst
[15.12.2022 15:50Uhr]
-Fix: FF108+ -> Position der vertikalen Tableiste korrigiert
[19.12.2022 19:58Uhr]
- Seite für neuen Tab wird aus Voreinstellungen gelesen
- kleinere optische Anpassungen
[21.12.2022 18:32Uhr]
- Fix: Menüleiste per 'alt'/'F10'-Key einblenden
[10.05.2023 00:08]
- Fix: Anpassungen Flex-Container
[10.05.2023 19:32]
- Fix: Anpassungen "Vertikale Tableiste"
/////////////////////////////////////////////////////////////////////////////////////*/


"use strict";

MultiRowTabs();
function MultiRowTabs() {
    
    if (!window.gBrowser){
        return;
    }

   // ----------------------------
// --- User-Settings: Start ---
// ----------------------------
// Position der Tab-Leiste:
//
var nTabbarPosition = 2; // [1] Tab-Leiste ist oberhalb aller Symbolleisten
// [2] Tab-Leiste ist unterhalb aller Symbolleisten, aber über dem Inhaltsbereich
// [3] Tab-Leiste ist vertikal auf der linken Seite
// [4] Tab-Leiste ist vertikal auf der linken Seite - Tableiste wird erst angezeigt bei Mausbewegung an den linken Rand (Autohide/Autopopup)
// [5] Tab-Leiste ist vertikal auf der rechten Seite
// [6] Tab-Leiste ist unterhalb des Inhaltsbereichs


// Tab-Größenangaben
//
var nTabWidth = 170; // Breite der einzelnen Tabs in Pixeln
var nTabHeight = 35; // Höhe der einzelnen Tabs in Pixeln
var nTabMargin = 1; // Abstand zwischen den Tab-Zeilen in Pixeln


// sonstige Einstellungen
//
var nTabLines = 7; // Anzahl der sichtbaren Tab-Zeilen, darüber hinaus wird gescrollt <nur bei horizontaler Ausrichtung (Position:[1],[2],[6]) - sonst keine Funktion>
var bTabScrollbar = true; // [true] Scrollbar für Tab-Leiste anzeigen, [false] Keine Scrollbar für Tab-Leiste anzeigen (Achtung: [false] = kein Scrollen mehr bei 'drag&drop' von Tabs!)
var bTabTooltips = true; // [true] Tab-Tooltips werden angezeigt, [false] Tab-Tooltips werden nicht angezeigt


// Tab-Schließen-Button
//
var bTabCloseButton = true; // [true] Tab-Schließen-Button anzeigen, [false] Tab-Schließen-Button verbergen
var bTabCloseButRounded = false; // [false] quadratische Darstellung, [true] abgerundete Darstellung
var nTabCloseButTransparency= 0.85; // Transparenzwert des Tab-Schließen-Button in Prozent. Wertebereich: [0]=vollständig durchscheinend bis [1]=vollständig deckend (z.B [0.75])
var nTabCloseIconNr = 0; // [0] Standard-Icon wird angezeigt
// [1] rotes Icon mit weißem Kreuz wird angezeigt
// [2] schwarzes Icon mit weißem Kreuz wird angezeigt
var nTabCloseButSize = 18; // Höhe und Breite des Tab-Schließen-Buttons in Pixeln


// FavIcon
//
var nFavIconSize = 16; // Höhe und Breite des 'FavIcons' und der Ladeanimation,[16] = Standard


// 'Throbber'-Animation
//
var bNewThroberAnimation = true; // [true] Alternative 'Throbber'-Animation auswählen, [false] Standard 'Throbber'-Animation beibehalten


// Hintergrundfarbe der Tabs (für einfarbige Darstellung müssen die RGB-Farbwerte 1 und 2 jeweils identisch sein)
//
var strTabSelColor1 = "240,152,0"; // RGB-Farbwert1 selektierter Tab
var strTabSelColor2 = "240,152,0"; // RGB-Farbwert2 selektierter Tab
var strTabNotSelColor1 = "195,157,116";// RGB-Farbwert1 nicht selektierter Tab
var strTabNotSelColor2 = "195,157,116";// RGB-Farbwert2 nicht selektierter Tab
var nTabTransparency = 1; // Transparenzwert des unselektierten Tab Hintergrundes. Wertebereich: [0]=vollständig durchscheinend bis [1]=vollständig deckend (z.B [0.75])


// Schriftart und Textdarstellung der Tabs
//
var strTabFontName = "Segoe UI"; // Name der Schriftart
var strTabFontColorSel = "255,255,255";// RGB-Farbwert der Schrift des selektierten Tabs
var strTabFontColorNotSel = "255,255,255";// RGB-Farbwert der Schrift des nicht selektierten Tabs
var nTabFontWeight = 600; // Stärke der Schrift: Wertebereich: [100] = sehr dünn bis [900] = sehr dick(bold). [500] = normal
var nTabFontSize = 12; // Größe/Höhe der Schrift in Pixeln
var bTabFontTextShadow = true; // [true] Text wird mit Schatteneffekt ausgegeben, [false] Text wird ohne Schatteneffekt ausgegeben. (Effekt nur bei selektierten Tabs!)
var bMarkUnreadTab = false; // [true] Kursive Schrift für ungelesene Tabs, [false] ungelesene Tabs werden nicht hervorgehoben


// Rahmen um einzelne Tabs
//
var nTabBorderWidth = 0; // Breite des Tab-Rahmen ([0] = kein sichtbarer Rahmen)
var nTabBorderRadius = 30; // Radius für abgerundete Ecken des Tabs ([0] = rechteckig, [80] = ideal abgerundet ).
var strTabBorderColor = "128,128,128";// RGB-Farbwert des Rahmens


// Neuer-Tab-Button
//
var strNewTabButtonColor = "255,255,255";// RGB-Farbwert des '+'-Zeichens


// Hintergrund der Tab-Leiste (für einfarbige Darstellung müssen die RGB-Farbwerte 1 und 2 jeweils identisch sein)
//
var strTabBarBgColor1 = "21,21,12"; // RGB-Farbwert1 für Hintergrund der Tab-Leiste
var strTabBarBgColor2 = "62,75,84"; // RGB-Farbwert2 für Hintergrund der Tab-Leiste




var nTabBarTransparency = 0; // Transparenzwert des Tab-Leisten Hintergrundes. Wertebereich: [0]=vollständig durchscheinend bis [1]=vollständig deckend
var strTabBarBgImagePath = ""; // Absoluter Dateipfad zu einem gepeicherten Bild (z.B.: "D://Bilder//Firefox//Hintergrund.jpg" )
// "D://Programme%20(Portable)//Firefox%20Portable//FireFox%20ESR%2091//Profilordner//chrome//image//NavToolbarBackground02.png"
var bTabBarBgImageRepeat = false; // [true] Bild wird für den gesamten Bereich mehrfach nebeneinander angezeigt, [false] Bild wird nur einmal angezeigt (Position: linke/obere Ecke)


// Einstellungen für vertikale Tab-Leiste
//
var nVerticalTabbarWidth = 215; // Breite der Vertikalen Tab-Leiste in Pixeln <nur bei vertikaler Ausrichtung (Position:[3],[4],[5]) - sonst keine Funktion>
var nVerticalAutoPopupHover = 2; // Abstand zum linken Fensterrand in Pixeln, ab der die vertikale Tab-Leiste sichtbar gemacht wird <Position[4] - sonst keine Funktion>
var nVerticalAutoPopupAnim = 0.5; // Dauer der Animation beim 'Herausschieben' des vertikalen Tab-Leiste in Sekunden ([0] = keine Animation) <Position[4] - sonst keine Funktion>


// Einstellungen für Maus-Bedienung
//
var bTabWheel = false; // [true]: Tab-Wheel-Selection(=Selektieren des nächsten/vorherigen Tabs mit dem Mausrad) einschalten, [false]: Tab-Wheel-Selection ausschalten
var bPageScroll = true; // [true]: seitenweises Scrollen, [false]: zeilenweises Scrollen
var bDblclickOnTabbarNewTab = true; // [true] Doppel-Klick über Tabbar öffnet neuen Tab, [false] Funktion wird nicht ausgeführt
var bDblclickOnTabReloadTab = true; // [true] Doppel-Klick über Tab lädt diesen neu, [false] Funktion wird nicht ausgeführt




// ----------------------------
// --- User-Settings: Ende ---
// ----------------------------

    
    Cu.import("resource://gre/modules/Services.jsm");
    let strHomepageURL;
    try {
      strHomepageURL = Services.prefs.getCharPref('browser.startup.homepage');
      console.log("homepage: " + strHomepageURL);
    } catch(e) {
        console.log("Error Homepage-String loading...");
    }
        
         
    if( nTabbarPosition < 1 || nTabbarPosition > 6 ) {
        nTabbarPosition = 1;
    }
    
    // Tab-Leiste ganz unten 
    if( nTabbarPosition == 6 )
    {
            let tabbarBoxBottom = document.createXULElement('vbox');
            tabbarBoxBottom.id = 'tabbarboxbottom';
            tabbarBoxBottom.style.background = '#000000';
        
            document.getElementById("navigator-toolbox").parentNode.parentNode.insertBefore( tabbarBoxBottom, document.getElementById("browser-bottombox"));
            let tabbar = document.getElementById("TabsToolbar");
            tabbarBoxBottom.appendChild(tabbar);
    }
    
    //Tableiste vertikal
    if(nTabbarPosition == 3 || nTabbarPosition == 5 )
    {
            let nTabbarWidth = nVerticalTabbarWidth;
            
            let tabbarBox = document.createXULElement('vbox');
            tabbarBox.id = 'tabbar-box';
            tabbarBox.style.width = nVerticalTabbarWidth + 'px';
            tabbarBox.style.background = '#000000';
        
            // Platz für Tab-Leiste auf der linken Seite 
            if(nTabbarPosition == 3) {
                let sidebarBox = document.getElementById('sidebar-box');
                sidebarBox.parentNode.insertBefore(tabbarBox, sidebarBox);
            }
            // Platz für Tab-Leiste auf der rechten Seite 
            else if( nTabbarPosition == 5) {
                document.getElementById("browser").insertBefore(tabbarBox,document.getElementById("browser").lastChild.nextSibling);
            }
        
    }

    tabsetting: { 
        let css =` 
            tabs tab {
                border-left: solid 1px hsla(0,0%,0%,0) !important;
                border-right: solid 1px hsla(0,0%,0%,0) !important;
                z-index: 2 !important;
            }
            tabs tab:after,tabs tab:before
            { 
                display: none !important; 
            }
    
        `;

        let sss = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
        let uri = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(css));
        sss.loadAndRegisterSheet(uri, sss.AUTHOR_SHEET);
    }

        
    //var nTabLineHeight = nTabHeight+2*nTabMargin;
    nTabMargin *= 2;
    var nTabLineHeight = nTabHeight+nTabMargin;
    
    //console.log("Margin: " + nTabMargin );
    
    multiLineTabSetup: {
        
        let service,uri,cssIn,cssOut;
        
        // ---
        // CSS-Icon-Settings 
        // ---
        cssIn =`
            
     
            /* Tab-Schließen-Button auf allen Tabs anzeigen oder verbergen */
            .tabbrowser-tab:not([pinned]) .tab-close-button, 
            .tabbrowser-tab:not([pinned]) .tab-close-button:not([selected="true"]) {
                display: __strTabCloseVisible__ !important;
            }
        
            /* Icon für Tab-Schließen-Button anzeigen */
            .tabbrowser-tab:not([pinned]) .close-icon {
                __CloseIcon1DisableStart__ list-style-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAGvSURBVEhLtZY/T8JAGMav7aDVgWriAIMJuBkGJmLCQBhcWGXgIzjKwuzMogkfgYWY+AEcWZkaFidJMCE0cSAmBuxg1Kfc21x7f+pQfwO8d/e+z3N3bxuw2C+Ptdrdeal0gzgPwu2WvazX91e+37PyFifIxHput7/5XK7AANjR5z+w57rRt9HAKRZ5pMeUAxOtwVGnw86GQ7Zfr/MZGawhB7k6lAYoOOl2o/i031eaYA5rALk6k8iAGgJwZBIn0iaiOIEa8boSTaaGYPJrtWKvg0E0FiETlThADWoBdEjT8lst6THFok5IBcTfJxM+ShL3gBwBdvA5nSpPkobExXoxjg3ozmgRYxSaTMSdUz0QY+kEaaO/QvnpOuMJCs2msQ9YQw6genH3IDYgKCFLnBBNVEgGQCeOO1f1xGQiGRxUKlpxNFTXeNSgNo1ksJnP2dt4zEc7xKcFqExQg9o0znW5fMvjmI/ZjNmOww6rVUmcCBcLFi6XrNBoROLBaMRXkijfZAJHVu1KJCtH2WQiSxxk5RgN8sDGDzOPcwfazkMQPF16nnfsuhd8Phd2f1v83g8tDtlXrvpOswAAAABJRU5ErkJggg==") !important; __CloseIcon1DisableEnd__
                __CloseIcon2DisableStart__ list-style-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsIAAA7CARUoSoAAAADySURBVEhL3ZZNDoIwEIVRFrInYefWkHAFb+CZ2XgKViZ6CHam9jVTU+ij7YJx4SRfSufnDW0oUFlrz03ztKPZE9FsKw1xD7QPMlGzo4xqlmxwqmu52raSnGjvwLXvzX0czaXraBwghhzksrgQO1HwmCbznmc3sibwhTmJJkuHXbK7KxR61k1CcQ9qUBtqCZGDCmB+GwYHi7FVCtRJmzAy4oA6HbkmBeKAOr9gS5g4QIzVhKgfNBjtDFS3KCfuKWgSO5k45rs8pj85aKqvCg8KcFeJpbsYchLigDodG0tekMv5gy+a/TC/5Hp389qKvy1V+wFdzbVtREsxIQAAAABJRU5ErkJggg==") !important; __CloseIcon2DisableEnd__

                
                border-radius: __nBorderRadius__px !important;
                padding: 3px !important;
                width: __nTabCloseButSize__px !important;
                height: __nTabCloseButSize__px !important;
                filter: opacity(__nTabCloseButTransparency__%) drop-shadow(-1px -1px 1px rgba(0,0,0,0.15)) drop-shadow(0px -1px 1px rgba(255,255,255,0.15)) !important; 
            }
            
            /* Neuer Tab Button */
            #TabsToolbar #tabs-newtab-button > image {
                min-height: __nNewTabButtonSize__px !important;
                max-height: __nNewTabButtonSize__px !important;
                min-width: __nNewTabButtonSize__px !important;
                max-width: __nNewTabButtonSize__px !important;
                margin-top: -1px !important;
                margin-left: -3px !important;
                padding: 2px !important;
                fill: rgba(__strNewTabButtonColor__,1) !important;
            }
            
            
            /* Throbber Icon ändern */
            __NewThrowberDisableStart__
            .tab-throbber[busy]::before,
            .tab-throbber[progress]::before {
              width: 16px !important;
              height: 16px !important;
              animation: unset !important;
              -moz-context-properties: unset !important;
              fill: unset !important;
              opacity: unset !important;
            }
            .tab-throbber[busy]::before {
              background-image: url("data:image/png;base64,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") !important;
            }
            .tab-throbber-fallback[busy] {
              list-style-image: url("data:image/png;base64,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") !important;
            }
            .tab-throbber[progress]::before{
              background-image: url("data:image/png;base64,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") !important;
            }
            .tab-throbber-fallback[progress] {
              list-style-image: url("data:image/png;base64,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") !important;
            }
            __NewThrowberDisableEnd__
        
        `;
        
        cssOut = cssIn;
        
        if(bTabCloseButton) {
            cssOut = cssOut.replace("__strTabCloseVisible__", "initial");
        }    
        else {
            cssOut = cssOut.replace("__strTabCloseVisible__", "none");
            nTabCloseIconNr = 0;
        }
        
        if( nTabCloseIconNr == 1 ) {
            cssOut = cssOut.replace(/__CloseIcon1DisableStart__/g, ' ');
            cssOut = cssOut.replace(/__CloseIcon1DisableEnd__/g, ' ');
            cssOut = cssOut.replace(/__CloseIcon2DisableStart__/g, '/*');
            cssOut = cssOut.replace(/__CloseIcon2DisableEnd__/g, '*/');
        }        
        else if( nTabCloseIconNr == 2 ) {
            cssOut = cssOut.replace(/__CloseIcon1DisableStart__/g, '/*');
            cssOut = cssOut.replace(/__CloseIcon1DisableEnd__/g, '*/');
            cssOut = cssOut.replace(/__CloseIcon2DisableStart__/g, ' ');
            cssOut = cssOut.replace(/__CloseIcon2DisableEnd__/g, ' ');
        }
        else
        {
            cssOut = cssOut.replace(/__CloseIcon1DisableStart__/g, '/*');
            cssOut = cssOut.replace(/__CloseIcon1DisableEnd__/g, '*/');
            cssOut = cssOut.replace(/__CloseIcon2DisableStart__/g, '/*');
            cssOut = cssOut.replace(/__CloseIcon2DisableEnd__/g, '*/');
            
        }
        
        if(bTabCloseButRounded)
            cssOut = cssOut.replace(/__nBorderRadius__/g, 20);
        else
            cssOut = cssOut.replace(/__nBorderRadius__/g, 0);
        
        cssOut = cssOut.replace(/__nTabCloseButTransparency__/g, nTabCloseButTransparency*100);
        cssOut = cssOut.replace(/__nTabCloseButSize__/g, nTabCloseButSize);
        
        
        cssOut = cssOut.replace(/__nNewTabButtonSize__/g, nTabHeight);
        cssOut = cssOut.replace(/__strNewTabButtonColor__/g, strNewTabButtonColor);
        
        if(bNewThroberAnimation)
        {
            cssOut = cssOut.replace(/__NewThrowberDisableStart__/g, ' ');
            cssOut = cssOut.replace(/__NewThrowberDisableEnd__/g, ' ');
        }
        else
        {
            cssOut = cssOut.replace(/__NewThrowberDisableStart__/g, '/*');
            cssOut = cssOut.replace(/__NewThrowberDisableEnd__/g, '*/');
        }
 
        //console.log("cssOut1: " + cssOut );
        
        service = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
        uri = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(cssOut));
        service.loadAndRegisterSheet(uri, service.AUTHOR_SHEET);
       

        // ---
        // Scrollbars -> "no-drag"
        // ---

        cssIn =`
          scrollbar, scrollcorner, scrollbar thumb, scrollbar scrollbarbutton {
            -moz-window-dragging: no-drag !important;
        }
        `;
        
        service = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
        uri = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(cssIn));
        service.loadAndRegisterSheet(uri, service.AGENT_SHEET);

        



        cssIn =`

        :root[tabsintitlebar][sizemode="maximized"]  #titlebar,
        :root[tabsintitlebar][sizemode="normal"]  #titlebar {
            appearance: none !important;
        }

        .tabbrowser-tab {
            --tab-label-mask-size: 1em;
        }
        
        #tabbrowser-tabs[haspinnedtabs]:not([positionpinnedtabs]) > #tabbrowser-arrowscrollbox > .tabbrowser-tab[first-visible-unpinned-tab] {
            margin-inline-start: -1px !important; 
        }
        
        #tabbrowser-tab-tooltip {
            visibility: strTabTooltips !important;
        }
        
        #TabsToolbar > .titlebar-buttonbox-container,
        #main-window[sizemode="fullscreen"]  #window-controls {
            display: none !important;
        }    
            
        #TabsToolbar { 
            /* Hintergrund der Tab-Leiste setzen */
            __strTabBarBackground__
        }
        
                
                        
        /* Tab-Höhe */
        .tabbrowser-tab, .tab-stack, .tab-background {
            min-height: nTabHeightpx !important;
            max-height: nTabHeightpx !important;
            
            margin-top: 0px !important;
            margin-bottom: nTabMarginpx !important;
            
            margin-left: -1px !important;
            margin-right: 0px !important;
        }


        #tabbrowser-tabs .tab-label:not([fokus]){
            opacity: 1!important;
        }
    
    
            
        tabs > arrowscrollbox,
        tabs > arrowscrollbox::part(scrollbox-clip)        { 
            display: block; 
            contain: none !important; 
        }
        
              
        tabs > arrowscrollbox::part(scrollbox)    {
            display: flex !important;
            position: relative !important;
            flex-wrap: wrap !important; 
            overflow: visible !important; 
            overflow-x: hidden !important;
            overflow-y: strScrollbar !important;
        }
                
        .tabbrowser-tab:not([pinned]) {
			flex-grow: 0 !important;
            min-width: nTabWidthpx !important;             
        }
        
    
        /* Schriftart/Schriftgröße ändern */
        .tabbrowser-tab .tab-label {
            text-shadow: none !important; 
            color: rgb(strTabFontColorNotSel) !important; 
            font-weight: nTabFontWeight !important;
            font-size:   nTabFontSizepx !important;
            font-family: "strTabFontName" !important;
            font-style: normal; 
        }

        .tabbrowser-tab[selected="true"] .tab-label,
        .tabbrowser-tab[multiselected="true"] .tab-label {
            text-shadow: __strTextShadow__ !important; ;
            color: rgb(strTabFontColorSel) !important; 
            font-weight: nTabFontWeight !important;
            font-size:   nTabFontSizepx !important; 
            font-family: "strTabFontName" !important; 
            font-style: normal; 
        }
        
        /*Ungelesene Tabs werden markiert */
        .tabbrowser-tab[pending] .tab-label, .tabbrowser-tab[notselectedsinceload="true"] {
            font-style: __strMarkUnreadTab__ !important;
        }
        

        #TabsToolbar .tabbrowser-tab .tab-background
        {
            border-radius: nTabBorderRadiuspx !important; 
            border: nTabBorderWidthpx solid rgba(strTabBorderColor,0.66) !important;
        }

        
        /* Tab-Hintergrund  */
        /*--- selektiert ---*/
        .tab-background[selected=true]{
            background-image:  linear-gradient( rgba(strTabSelColor1,1), rgba(strTabSelColor2,1) ), none !important;
            filter: drop-shadow(2px 2px 2px rgba(0,0,0,0.5)) drop-shadow(-2px 2px 2px rgba(0,0,0,0.5)) !important; 
            border-radius: nTabBorderRadiuspx !important; 
        }
        /*--- hover: nicht selektiert ---*/
        .tabbrowser-tab:hover > .tab-stack > .tab-background:not([selected=true]) {
            filter: brightness(130%) contrast(110%) drop-shadow(1px 1px 1px rgba(0,0,0,0.5)) drop-shadow(-1px 1px 1px rgba(0,0,0,0.5)) !important; 
            border-radius: nTabBorderRadiuspx !important;    
        }
        .tabbrowser-tab:hover:not([selected=true]) :is(.tab-label,.tab-icon-stack) {
            filter: drop-shadow( 0px 0px 2px #AAAAAA) brightness(115%) !important; 
        }
        /*--- hover: Multi selektiert ---*/
        .tabbrowser-tab:hover > .tab-stack > .tab-background[multiselected=true]:not([selected=true]) {
            filter: brightness(120%) contrast(100%) drop-shadow(1px 1px 1px rgba(0,0,0,0.5)) drop-shadow(-1px 1px 1px rgba(0,0,0,0.5)) !important; 
            border-radius: nTabBorderRadiuspx !important;    
        }
        /*--- nicht selektiert ---*/
        .tab-background:not([selected=true]) {
            background-image:  linear-gradient( rgba(strTabNotSelColor1,nTabTransparency), rgba(strTabNotSelColor2,nTabTransparency) ),  none !important; 
            filter: brightness(115%) contrast(90%) drop-shadow(1px 1px 1px rgba(0,0,0,0.5)) drop-shadow(-1px 1px 1px rgba(0,0,0,0.5)) !important; 
            border-radius: nTabBorderRadiuspx !important; 
        }
        /*--- Multi selektiert ---*/
        .tab-background[multiselected=true]:not([selected=true]) {
            background-image:  linear-gradient( rgba(strTabSelColor1,1), rgba(strTabSelColor2,1) ), none !important;
            filter: brightness(130%) saturate(50%) drop-shadow(1px 1px 1px rgba(0,0,0,0.5)) drop-shadow(-1px 1px 1px rgba(0,0,0,0.5)) !important; 
            border-radius: nTabBorderRadiuspx !important; 
        }
    
        .tab-sharing-icon-overlay, .tab-icon-overlay:not([pinned]), .tab-icon-overlay[soundplaying] {
            transform:  scale(1.5) !important;  
        }
        
        .tabbrowser-tab .tab-label 
        {
            margin-top: -2px !important;
        }
            
        
        .tab-close-button
        {
            margin-top: -2px !important;
        }
        
        .tab-throbber, .tab-throbber-tabslist, .tab-icon-pending, .tab-icon-image, .tab-sharing-icon-overlay {
            height:     nFavIconSizepx !important;
            width:         nFavIconSizepx !important;
            fill: rgba(255,255,255,0.8) !important;
            margin-top: -2px !important;
        }    
        
        #tabbrowser-tabs, #tabbrowser-arrowscrollbox, #tabbrowser-tabs[positionpinnedtabs] > #tabbrowser-arrowscrollbox > .tabbrowser-tab[pinned] {
            min-height: 0 !important; 
        }        

        #tabbrowser-tabs {
            appearance: none !important;
        }
        
        .tabbrowser-tab:is([visuallyselected="true"], [multiselected]) > .tab-stack > .tab-background:-moz-lwtheme {
            box-shadow: none !important; 
        }
 
        
        `;

                
        // --- CSS-Parameter ersetzen ---
        cssOut = cssIn.replace(/nTabHeight/g, nTabHeight);
        cssOut = cssOut.replace(/nTabMargin/g, nTabMargin);
        cssOut = cssOut.replace(/nTabWidth/g, nTabWidth);
        
                
        if(bTabScrollbar) {
            cssOut = cssOut.replace("strScrollbar", "auto");
        }
        else {
            cssOut = cssOut.replace("strScrollbar", "hidden");
        }
        
        if(bTabTooltips) 
            cssOut = cssOut.replace("strTabTooltips", "visible");
        else
            cssOut = cssOut.replace("strTabTooltips", "hidden");
                
        cssOut = cssOut.replace(/strTabSelColor1/g, strTabSelColor1);
        cssOut = cssOut.replace(/strTabSelColor2/g, strTabSelColor2);
        cssOut = cssOut.replace(/strTabNotSelColor1/g, strTabNotSelColor1);
        cssOut = cssOut.replace(/strTabNotSelColor2/g, strTabNotSelColor2);
        cssOut = cssOut.replace(/nTabBorderRadius/g, nTabBorderRadius);
        cssOut = cssOut.replace(/nTabBorderWidth/g, nTabBorderWidth);
        cssOut = cssOut.replace(/strTabBorderColor/g, strTabBorderColor);
        cssOut = cssOut.replace(/nTabTransparency/g, nTabTransparency);
        
        cssOut = cssOut.replace(/strTabFontName/g, strTabFontName);
        cssOut = cssOut.replace(/strTabFontColorSel/g, strTabFontColorSel);
        cssOut = cssOut.replace(/strTabFontColorNotSel/g, strTabFontColorNotSel);
        cssOut = cssOut.replace(/nTabFontSize/g, nTabFontSize);
        cssOut = cssOut.replace(/nTabFontWeight/g, nTabFontWeight);
        
        if (bTabFontTextShadow)
            cssOut = cssOut.replace(/__strTextShadow__/g, "1px 1px 0px #000000");
        else
            cssOut = cssOut.replace(/__strTextShadow__/g, "none");
        
        
        if( bMarkUnreadTab )
          cssOut = cssOut.replace(/__strMarkUnreadTab__/g, "italic");
        else
          cssOut = cssOut.replace(/__strMarkUnreadTab__/g, "normal");
        
        
            
        let strTabBarBackgroundOut = "";
        if( strTabBarBgImagePath ) {
            if( bTabBarBgImageRepeat ) {
                strTabBarBackgroundOut = "background: #000000 url(\"file:" + strTabBarBgImagePath + "\") repeat !important;";
            }
            else {
                strTabBarBackgroundOut = "background: #000000 url(\"file:" + strTabBarBgImagePath + "\") no-repeat !important;";
            }
        }
        else {
             strTabBarBackgroundOut = "background-image: linear-gradient( rgba(" + strTabBarBgColor1 + "," + nTabBarTransparency +"), rgba(" + strTabBarBgColor2 + "," + nTabBarTransparency + ") ) !important;";
        }
                        
        cssOut = cssOut.replace(/__strTabBarBackground__/g, strTabBarBackgroundOut);
        
        cssOut = cssOut.replace(/nFavIconSize/g, nFavIconSize);
                        
        //console.log("CSSOut: " + cssOut );

     
        service = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
        uri = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(cssOut));
        service.loadAndRegisterSheet(uri, service.AUTHOR_SHEET);
                
        let tabsScrollbox     = document.getElementById('tabbrowser-arrowscrollbox').scrollbox;
        
        tabsScrollbox.style.minHeight      =  nTabLineHeight +'px';
        tabsScrollbox.style.maxHeight      =  nTabLineHeight*nTabLines +'px';
        
        //console.log("tabsScrollbox: " + tabsScrollbox );
        
    }

    
    if( nTabbarPosition >= 2 && nTabbarPosition <= 5 ) {
        let tabbar = document.getElementById("TabsToolbar");
        tabbar.parentNode.parentNode.appendChild(tabbar);
    }

    
    if( nTabbarPosition >= 3 && nTabbarPosition <= 5 )
    {
        let cssIn =`
        
        .StyleShowingTabsToolbar {
            transition:                margin-left nVerticalAutoPopupAnims !important; 
            display:                   flex !important;
			position:                  absolute !important;
            opacity:                   1;
            margin-left:               0px;
            z-index:                   100 !important;
            min-width:                 nVerticalTabbarWidthpx !important;
            filter:                    drop-shadow(4px 3px 2px rgba(0,0,0,0.33)) !important; 
        }
        
                
        .StyleHidingTabsToolbar {
            display:                   flex !important;
			position:                  absolute !important;
            opacity:                   0;
            margin-left:               calc( (nVerticalTabbarWidthpx - nVerticalAutoPopupHoverpx) * -1 ); 
            z-index:                   100 !important;
            min-width:                 nVerticalTabbarWidthpx !important;
        }
  
		.toolbar-items[align="end"] {
			display:initial !important;
		}
  
        tabs > arrowscrollbox { 
            display:  flex !important;
            position: absolute !important;
            min-width: nVerticalTabbarWidthpx !important;
        }
    
        `;
    
        let cssOut;
        
        if ( nTabbarPosition != 4 ) {
            nVerticalAutoPopupAnim = 0;
        }        
        
                        
        cssOut = cssIn.replace(/nVerticalTabbarWidth/g, nVerticalTabbarWidth);
        cssOut = cssOut.replace(/nVerticalAutoPopupHover/g, nVerticalAutoPopupHover);
        cssOut = cssOut.replace(/nVerticalAutoPopupAnim/g, nVerticalAutoPopupAnim);
        
                        
        let sss = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
        let uri = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(cssOut));
        sss.loadAndRegisterSheet(uri, sss.AUTHOR_SHEET);
    

        
        let tabsToolbar =  document.getElementById('TabsToolbar');
        
        if ( nTabbarPosition == 4 )
        {
            tabsToolbar.classList.add('StyleHidingTabsToolbar');
        }
        else
        {
            tabsToolbar.classList.add('StyleShowingTabsToolbar');
        }
        
    }

//------------------------------------------------------------------------------------------
    
    var tabsToolbar     = document.getElementById('TabsToolbar');
    var tabbrowsertabs     = document.getElementById('tabbrowser-tabs');
    var tabsscrollbox    = document.getElementById('tabbrowser-arrowscrollbox');
    var ScrollBox = tabsscrollbox.scrollbox;    

    var bMouseEnter = false;
    var bToolbarLocked = false;

    // ----------------------------------
    // Load-Event:  
    // ----------------------------------
    function onReady() 
    {    
        console.log("OnReady");
        
        let cssElements =`
            #alltabs-button,
            hbox.titlebar-spacer/*,
            [class="scrollbutton-up"],
            [class="scrollbutton-up"] + spacer,
            scrollbox[part][orient="horizontal"] + spacer,
            [class="scrollbutton-down"]*/ { 
                display: none !important; 
            }
            
            #tabbrowser-arrowscrollbox::part(scrollbutton-up), 
            #tabbrowser-arrowscrollbox::part(scrollbutton-down) {
                display: none !important;
            }
            
            
        `;
        
        let service = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
        let ur         = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(cssElements));
        service.loadAndRegisterSheet(ur, service.AUTHOR_SHEET);
    
        gBrowser.selectedTab.scrollIntoView(); 
    }    
    
    
    if (window.readyState !== "loading") {
        setTimeout(onReady,350); 
    }
    else 
    {
        window.addEventListener("DOMContentLoaded", onReady );
    }
    
    // ----------------------------------
    // ResizeObserver / Client
    // ----------------------------------
    var resizeClientObserver=null;
    
    let navigatorToolbox = document.getElementById('navigator-toolbox');
    let mainWindow = document.getElementById('main-window');
    
    if( nTabbarPosition >= 3 && nTabbarPosition <= 5 )
    {
        resizeClientObserver = new ResizeObserver(function(entries) {
            for (let entry of entries) {
                
                tabsToolbar.style.minHeight = tabsToolbar.style.maxHeight = entry.contentRect.height + 'px';
                ScrollBox.style.maxHeight = entry.contentRect.height + 'px';
                
                tabsToolbar.style.top = navigatorToolbox.clientHeight + 'px';
                                
                if(mainWindow.getAttribute('inFullscreen') == 'true' ) {
                    if (navigatorToolbox.style.marginTop != "") {
                        tabsToolbar.style.top = '0px';
                    }
                }
                
                if( nTabbarPosition == 5 )    {
                    tabsToolbar.style.marginLeft = (entry.contentRect.width - nVerticalTabbarWidth) + 'px';
                }
            }
        });
                
        resizeClientObserver.observe(document.getElementById("browser"));            
    }  


    // ----------------------------------
    // ToggleMenuObserver
    // ----------------------------------
    if( nTabbarPosition == 2 || nTabbarPosition == 6) {
        let observerToggleMenu=null;
        let configObserver=null;
        
        let bTabsintitlebar = document.querySelector('html#main-window').getAttribute('tabsintitlebar');
        let titlebar = document.querySelector('#navigator-toolbox>vbox#titlebar');
        let targetMenubar = document.getElementById('toolbar-menubar');

        const callback = (mutationList, observer) => {
            for (const mutation of mutationList) {
                if (mutation.type === 'attributes') {
                    let bAutohide = targetMenubar.getAttribute('autohide');
                    let bInacive = targetMenubar.getAttribute('inactive');
                    if(bInactive == 'true')    {
                        titlebar.style.display = "none";
                        console.log("titlebar.style.display = none");
                    }
                    else {
                        titlebar.style.display = "initial";
                        console.log("titlebar.style.display = initial");
                        
                    }
                }
            }
        }
    
        observerToggleMenu = new MutationObserver(callback);
        configObserver = { attributes: true, attributeFilter: ['autohide','inactive'] };
        
        observerToggleMenu.observe(targetMenubar, configObserver);    
    }

    // ----------------------------------
    // 'Middleclick' on Tab -> Close Tab
    // ----------------------------------
    gBrowser.tabContainer.addEventListener('click', function(event) 
    {
        if (event.button == 1)
        {
            let element = event.target.parentNode;
            while(element)
            {
                if (element.localName == 'tab') 
                {
                    gBrowser.removeTab(element, {animate: false});
                    event.preventDefault();
                    event.stopPropagation();    
                    return;
                }
                
                element = element.parentNode;
            }
            
        };
    
    }, true);

    // ----------------------------------
    // 'Middleclick' on TabsToolbar -> Add Tab
    // ----------------------------------
    tabsToolbar.addEventListener('click', function(event)
    {
        if (event.button == 1)
        {
            if(event.target.parentNode.id == "TabsToolbar") 
            { 
               event.target.ownerGlobal.openTrustedLinkIn(strHomepageURL,"tab");
               return;
            }
        };
    }, true);

    
    // ----------------------------------
    // 'Doubleclick' on TabsToolbar -> Add Tab
    // ----------------------------------
    tabsToolbar.addEventListener('dblclick', function(event)
    {
        if(!bDblclickOnTabbarNewTab)
            return;
        
        if (event.button == 0)
        {  
				
            if(event.target.parentNode.id == "TabsToolbar") 
            {
               event.target.ownerGlobal.openTrustedLinkIn(strHomepageURL,"tab");
               
               event.preventDefault();
               event.stopPropagation();    
               return;
            }
        };
    }, true);
        
        
        
    // ----------------------------------
    // 'Doubleclick' on TabsContainer -> Add Tab
    // ----------------------------------
    gBrowser.tabContainer.addEventListener('dblclick', function(event)
    {
        if(!bDblclickOnTabbarNewTab)
            return;
        
        if (event.button == 0)
        {  
               let element = event.target.parentNode;
            if (element == gBrowser.tabContainer ) 
            {
               event.target.ownerGlobal.openTrustedLinkIn(strHomepageURL,"tab");
    
               event.preventDefault();
               event.stopPropagation();    
               return;
            }
        };
    }, true);
    
    
    // ----------------------------------
    // 'Doubleclick' on Tab -> Reload Tab
    // ----------------------------------
    gBrowser.tabContainer.addEventListener('dblclick', function(event) 
    {
        if(!bDblclickOnTabReloadTab)
            return;
        
        if (event.button == 0)
        {
            let element = event.target.parentNode;
            while (element) 
            {
                if (element.localName == 'tab') 
                {
                    element.linkedBrowser.reload();
                    
                    return;
                }
                 
                element = element.parentNode;
            }
        }
    }, true);
    
    // ----------------------------------
    // 'mouseenter'
    // ----------------------------------
    tabsToolbar.addEventListener('mouseenter', event => {
        if( nTabbarPosition == 4  ) 
        {
            if(!bMouseEnter)
            {
                bMouseEnter = true;
                
                tabsToolbar.classList.add('StyleShowingTabsToolbar');    
                tabsToolbar.classList.remove('StyleHidingTabsToolbar');
                
            }
        }
    }, true);
    
    // ----------------------------------
    // 'mouseleave'
    // ----------------------------------
    tabsToolbar.addEventListener('mouseleave', event => {
        if( nTabbarPosition == 4 ) 
        {    
            if(bMouseEnter)
            {      
                            
                if( event.clientX >= 0 &&
                    event.offsetY > tabsToolbar.clientTop  &&
                    event.offsetX < tabsToolbar.clientWidth &&
                    event.offsetY < tabsToolbar.clientHeight )
                {
                    return;
                }
        
                event.preventDefault();
                event.stopPropagation();
                
                
                tabsToolbar.classList.add('StyleHidingTabsToolbar');
                tabsToolbar.classList.remove('StyleShowingTabsToolbar');
                

                bMouseEnter = false;
            }
        }                
    }, false);


    
    // ...  
    // TabSelect-Event:  
    // ...
    gBrowser.tabContainer.addEventListener("TabSelect", function(event) {
                
        let bScroll    = false;
        let bScrollTop = true;
                
        let scrollBoxY1     = event.target.parentElement.scrollbox.screenY;
        let scrollBoxHeight = event.target.parentElement.scrollbox.clientHeight;
        let scrollBoxY2     = scrollBoxY1+scrollBoxHeight;
        
        let TabSelY1     = event.target.screenY;
        let TabSelHeight = event.target.clientHeight;
        let TabSelY2     = TabSelY1+TabSelHeight;
        
        
        
        if( TabSelY2 > scrollBoxY2 )
        {
            bScroll = true;
            bScrollTop = false;
        }
        if( TabSelY1 < scrollBoxY1 ) 
        {
            bScroll = true;
            bScrollTop = true;
        }
        
        if( bScroll )
        {
            setTimeout(function() 
            {
                event.target.scrollIntoView(bScrollTop);
                //gBrowser.selectedTab.scrollIntoView(); 
                //console.log("TabSelect_IntoView:" + bScrollTop );    
            }, 0);
        }
        
       //console.log("TabSelect:" + bScroll );    
        
    }, true);
      
    
      
      
    // ...  
    // Drag-Event: Start  
    // ...
    gBrowser.tabContainer.addEventListener("dragstart",  function(event) {
        //console.log("dragstart..." );    
        if(nTabLines==1 && ( nTabbarPosition == 1 || nTabbarPosition == 2 || nTabbarPosition == 6 )) {
            let tabsScrollbox  = document.getElementById('tabbrowser-arrowscrollbox').scrollbox;
            tabsScrollbox.style.maxHeight      =  nTabLineHeight*3 +'px';
            event.target.scrollIntoView(false);
        }
    }, false);

    // ...  
    // Drag-Event: Ende  
    // ...
    gBrowser.tabContainer.addEventListener("dragend",  function(event) {
        //console.log("dragend..." );    
        if(nTabLines==1 && ( nTabbarPosition == 1 || nTabbarPosition == 2 || nTabbarPosition == 6 )) {
            let tabsScrollbox  = document.getElementById('tabbrowser-arrowscrollbox').scrollbox;
            tabsScrollbox.style.maxHeight      =  nTabLineHeight +'px';
            event.target.scrollIntoView(false);
        }
    }, false);
    
    
    // ...  
    // Wheel-Event:  
    // ...
    let tabsScrollbox  = document.getElementById('tabbrowser-arrowscrollbox').scrollbox;
    tabsScrollbox.addEventListener("wheel", function(event) 
    {
        event.preventDefault();
        event.stopPropagation();
        
            
        let scrollUp        = true;
        let wrap            = false;
        let scrollBoxY1     = gBrowser.tabContainer._animateElement.scrollbox.scrollTop; 
        let scrollHeight;
        
        if(bPageScroll)
            {scrollHeight  = gBrowser.tabContainer._animateElement.scrollbox.clientHeight;}
        else            
            {scrollHeight  = nTabLineHeight;}
        
        let dir = (scrollUp ? 1 : -1) * Math.sign(event.deltaY);
        
        let bLastScrollLine = false; 
        
        if( gBrowser.tabContainer._animateElement.scrollbox.scrollTopMax == gBrowser.tabContainer._animateElement.scrollbox.scrollTop)
            {
                bLastScrollLine = true;
            }        
        

        if( !bTabWheel || event.ctrlKey || event.originalTarget.localName == "thumb"  || event.originalTarget.localName == "slider" || event.originalTarget.localName == "scrollbarbutton" ) 
        {
              setTimeout(function()
            {
                let scrollBoxMod = scrollBoxY1%scrollHeight;
                
                if( scrollBoxMod > 0 )
                {
                    if( dir == -1 )
                    {
                        scrollBoxY1 -= scrollBoxMod;
                        if(scrollBoxMod < nTabLineHeight && !bLastScrollLine) { scrollBoxY1 -= scrollHeight; }
                
                    }
                    else
                    {
                        scrollBoxY1 += (scrollHeight-(scrollBoxMod));
                        if(scrollHeight-(scrollBoxMod) < nTabLineHeight) { scrollBoxY1 += scrollHeight; }
                        
                    }
                }
                else
                {
                    if( dir == -1 )
                    {
                        scrollBoxY1 -= scrollHeight;
                    }
                    else
                    {
                        scrollBoxY1 += scrollHeight;
                    }
                }
                
                gBrowser.tabContainer._animateElement.scrollbox.scrollTo({ top: scrollBoxY1, left: 0, behavior: 'auto'}); 
            }, 20);
        }
        

        if( bTabWheel && !event.ctrlKey )
        {    
            setTimeout(function()
            {
                if( event.originalTarget.localName != "slider" && 
                    event.originalTarget.localName != "thumb"  &&
                    event.originalTarget.localName != "scrollbarbutton" )
                {
                    gBrowser.tabContainer.advanceSelectedTab(dir, wrap);
                    if( (gBrowser.tabContainer._firstTab == gBrowser.selectedTab) || 
                        (gBrowser.tabContainer._lastTab  == gBrowser.selectedTab)     )
                        {
                            gBrowser.selectedTab.scrollIntoView(); 
                        }
        
                }    
            }, 50);
        }


    }, false);
        

//-------------------------------------------------------------------------------------------
 
    gBrowser.tabContainer.clearDropIndicator = function() {
        var tabs = this.allTabs;
        for (let i = 0, len = tabs.length; i < len; i++) {
            tabs[i].style.removeProperty("border-left-color");
            tabs[i].style.removeProperty("border-right-color");
        }
    }
    gBrowser.tabContainer.addEventListener("dragleave", function(event) {  this.clearDropIndicator(event); }, true);



    gBrowser.tabContainer.on_dragover = function(event) {
        this.clearDropIndicator();
        var effects = this.getDropEffectForTabDrag(event);
        var ind = this._tabDropIndicator;
        if (effects == "" || effects == "none") {
            ind.hidden = true;
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        if (effects == "link") {
            let tab = this._getDragTargetTab(event, true);
            if (tab) {
                if (!this._dragTime) {
                    this._dragTime = Date.now();
                }
                if (Date.now() >= this._dragTime + this._dragOverDelay) {
                    this.selectedItem = tab;
                }
                ind.hidden = true;
                return;
            }
        }
        let newIndex = this._getDropIndex(event, effects == "link");
        let children = this.allTabs;
        if (newIndex == children.length) {
            children[newIndex - 1].style.setProperty("border-right-color","red","important");
        } else {
            children[newIndex].style.setProperty("border-left-color","red","important");
        }
    }

    gBrowser.tabContainer.on_drop = function(event) {
        this.clearDropIndicator();
        var dt = event.dataTransfer;
        var dropEffect = dt.dropEffect;
        var draggedTab;
        let movingTabs;
        if (dt.mozTypesAt(0)[0] == TAB_DROP_TYPE) {
            // tab copy or move
            draggedTab = dt.mozGetDataAt(TAB_DROP_TYPE, 0);
            // not our drop then
            if (!draggedTab) {
                return;
            }
            movingTabs = draggedTab._dragData.movingTabs;
            draggedTab.container._finishGroupSelectedTabs(draggedTab);
        }
        this._tabDropIndicator.hidden = true;
        event.stopPropagation();
        if (draggedTab && dropEffect == "copy") {
            // copy the dropped tab (wherever it's from)
            let newIndex = this._getDropIndex(event, false);
            let draggedTabCopy;
            for (let tab of movingTabs) {
                let newTab = gBrowser.duplicateTab(tab);
                gBrowser.moveTabTo(newTab, newIndex++);
                if (tab == draggedTab) {
                    draggedTabCopy = newTab;
                }
            }
            if (draggedTab.container != this || event.shiftKey) {
                this.selectedItem = draggedTabCopy;
            }
        } else if (draggedTab && draggedTab.container == this) {
            let oldTranslateX = Math.round(draggedTab._dragData.translateX);
            let tabWidth = Math.round(draggedTab._dragData.tabWidth);
            let translateOffset = oldTranslateX % tabWidth;
            let newTranslateX = oldTranslateX - translateOffset;
            if (oldTranslateX > 0 && translateOffset > tabWidth / 2) {
                newTranslateX += tabWidth;
            } else if (oldTranslateX < 0 && -translateOffset > tabWidth / 2) {
                newTranslateX -= tabWidth;
            }
            let dropIndex = this._getDropIndex(event, false);
            //  "animDropIndex" in draggedTab._dragData &&
            //  draggedTab._dragData.animDropIndex;
            let incrementDropIndex = true;
            if (dropIndex && dropIndex > movingTabs[0]._tPos) {
                dropIndex--;
                incrementDropIndex = false;
            }
            let animate = gBrowser.animationsEnabled;
            if (oldTranslateX && oldTranslateX != newTranslateX && animate) {
                for (let tab of movingTabs) {
                    tab.setAttribute("tabdrop-samewindow", "true");
                    tab.style.transform = "translateX(" + newTranslateX + "px)";
                    let onTransitionEnd = transitionendEvent => {
                        if (
                            transitionendEvent.propertyName != "transform" ||
                            transitionendEvent.originalTarget != tab
                        ) {
                            return;
                        }
                        tab.removeEventListener("transitionend", onTransitionEnd);
                        tab.removeAttribute("tabdrop-samewindow");
                        this._finishAnimateTabMove();
                        if (dropIndex !== false) {
                            gBrowser.moveTabTo(tab, dropIndex);
                            if (incrementDropIndex) {
                                dropIndex++;
                            }
                        }
                        gBrowser.syncThrobberAnimations(tab);
                    };
                    tab.addEventListener("transitionend", onTransitionEnd);
                }
            } else {
                this._finishAnimateTabMove();
                if (dropIndex !== false) {
                    for (let tab of movingTabs) {
                        gBrowser.moveTabTo(tab, dropIndex);
                        if (incrementDropIndex) {
                            dropIndex++;
                        }
                    }
                }
            }
        } else if (draggedTab) {
            let newIndex = this._getDropIndex(event, false);
            let newTabs = [];
            for (let tab of movingTabs) {
                let newTab = gBrowser.adoptTab(tab, newIndex++, tab == draggedTab);
                newTabs.push(newTab);
            }
            // Restore tab selection
            gBrowser.addRangeToMultiSelectedTabs(
                newTabs[0],
                newTabs[newTabs.length - 1]
            );
        } else {
            // Pass true to disallow dropping javascript: or data: urls
            let links;
            try {
                links = browserDragAndDrop.dropLinks(event, true);
            } catch (ex) {}
            if (!links || links.length === 0) {
                return;
            }
            let inBackground = Services.prefs.getBoolPref(
                "browser.tabs.loadInBackground"
            );
            if (event.shiftKey) {
                inBackground = !inBackground;
            }
            let targetTab = this._getDragTargetTab(event, true);
            let userContextId = this.selectedItem.getAttribute("usercontextid");
            let replace = !!targetTab;
            let newIndex = this._getDropIndex(event, true);
            let urls = links.map(link => link.url);
            let csp = browserDragAndDrop.getCSP(event);
            let triggeringPrincipal = browserDragAndDrop.getTriggeringPrincipal(
                event
            );
            (async () => {
                if (
                    urls.length >=
                    Services.prefs.getIntPref("browser.tabs.maxOpenBeforeWarn")
                ) {
                    // Sync dialog cannot be used inside drop event handler.
                    let answer = await OpenInTabsUtils.promiseConfirmOpenInTabs(
                        urls.length,
                        window
                    );
                    if (!answer) {
                        return;
                    }
                }
                gBrowser.loadTabs(urls, {
                    inBackground,
                    replace,
                    allowThirdPartyFixup: true,
                    targetTab,
                    newIndex,
                    userContextId,
                    triggeringPrincipal,
                    csp,
                });
            })();
        }
        if (draggedTab) {
            delete draggedTab._dragData;
        }
    }

    gBrowser.tabContainer._getDropIndex = function(event, isLink) {
        var tabs = this.allTabs;
        var tab = this._getDragTargetTab(event, isLink);
        if (!RTL_UI) {
            for (let i = tab ? tab._tPos : 0; i < tabs.length; i++) {
                if (
                    event.screenY <
                    tabs[i].screenY + tabs[i].getBoundingClientRect().height
                ) {
                    if (
                        event.screenX <
                        tabs[i].screenX + tabs[i].getBoundingClientRect().width / 2
                    ) {
                        return i;
                    }
                    if (
                        event.screenX >
                        tabs[i].screenX + tabs[i].getBoundingClientRect().width / 2 &&
                        event.screenX <
                        tabs[i].screenX + tabs[i].getBoundingClientRect().width
                    ) {
                        return i + 1;
                    }
                }
            }
        } else {
            for (let i = tab ? tab._tPos : 0; i < tabs.length; i++) {
                if (
                    event.screenY <
                    tabs[i].screenY + tabs[i].getBoundingClientRect().height
                ) {
                    if (
                        event.screenX <
                        tabs[i].screenX + tabs[i].getBoundingClientRect().width &&
                        event.screenX >
                        tabs[i].screenX + tabs[i].getBoundingClientRect().width / 2
                    ) {
                        return i;
                    }
                    if (
                        event.screenX <
                        tabs[i].screenX + tabs[i].getBoundingClientRect().width / 2
                    ) {
                        return i + 1;
                    }
                }
            }
        }
        return tabs.length;
    }
}