document.addEventListener('DOMContentLoaded', function ()
{	
	i18n();
	
	chrome.runtime.sendMessage({ code: 'popupCreated' });
});

var selectedURL = null;

chrome.runtime.onMessage.addListener(function(request, sender, sendResponse)
{
	switch(request.code)
	{
		case 'updatePopup':
			var account = request.account;
			var url = request.url;
			var domain = getHost(url);
			var root = getRootDomain(url);
			var whitelist = account.whitelist;
			var cookies = request.cookies;
			var cookies3rdParty = request.cookies3rdParty;
			
			var activatedInfo = account.active ? i18nMessage('extension_activated') : i18nMessage('extension_deactivated');
			$('.activated_info').text(activatedInfo);
			$('#activated').prop('checked', account.active);
			$('#activated').off('click').click(function(e) 
			{
				var active = $(this).is(':checked');
				setKey('active', active);
				
				var activatedInfo = active ? i18nMessage('extension_activated') : i18nMessage('extension_deactivated');
				$('.activated_info').text(activatedInfo);
			});
			
			var i18nSingleCookie = cookies == 1 ? '_single' : '';
			var infoText = validURL(url) ? i18nMessage('force_delete_info' + i18nSingleCookie, [cookies, root]) : i18nMessage('force_delete_error');
			$('.force_delete_info').text(infoText);
			$('.force_delete_cookies').off('click').click(function(e) 
			{
				chrome.runtime.sendMessage({ code: 'delete', url: url, thirdParty: false });
			});
			if(cookies > 0)
				$('.force_delete_cookies').prop('disabled', false);
			else
				$('.force_delete_cookies').prop('disabled', true);
				
			//====3rdParty-Cookies====
			if(validURL(url))
			{
				if(cookies3rdParty == -1)
					cookies3rdParty = 0;
			
				i18nSingleCookie = cookies3rdParty == 1 ? '_single' : '';
				var infoText = i18nMessage('force_delete_3rdParty_info' + i18nSingleCookie, [cookies3rdParty, root]);
				$('.force_delete_3rdParty_info').text(infoText);
				$('.force_delete_3rdParty').off('click').click(function(e) 
				{
					chrome.runtime.sendMessage({ code: 'delete', url: url, thirdParty: true });
				});
				if(cookies3rdParty > 0)
					$('.force_delete_3rdParty').prop('disabled', false);
				else
					$('.force_delete_3rdParty').prop('disabled', true);
			}
			//====/3rdParty-Cookies====
			
			$('.open_whitelist').click(function(e)
			{
				chrome.runtime.openOptionsPage();
			});
			if(validURL(url))
			{
				var urls = [
					'*.' + root,
					domain
				];
				
				var updateSettings = function(url)
				{			
					$('.whitelist_toggle[value=' + getWhitelistType(whitelist, url) + ']').prop('checked', true);
					$('#whitelist_tab').off('click').click(function(e)
					{
						chrome.runtime.sendMessage({ code: 'whitelist', url: url, type: REMOVETYPE_TAB });
					});
					$('#whitelist_save').off('click').click(function(e)
					{
						chrome.runtime.sendMessage({ code: 'whitelist', url: url, type: REMOVETYPE_NEVER });
					});
					$('#whitelist_window').off('click').click(function(e)
					{
						chrome.runtime.sendMessage({ code: 'whitelist', url: url, type: REMOVETYPE_WINDOW });
					});
				
					$('#whitelist_3rdParty').prop('checked', thirdPartyKeep(account.whitelist3rdParty, url));
					$('#whitelist_3rdParty').off('click').click(function(e)
					{
						chrome.runtime.sendMessage({ code: 'whitelist3rdParty', url: url, save: $(this).is(':checked') });
					});
				
					var delay = getDelay(account.delays, url);
					var delaySet = delay !== 0;
					$('#delay_check').prop('checked', delaySet);
					$('#delay_check').off('click').click(function(e)
					{
						var checked = $(this).is(':checked');
						chrome.runtime.sendMessage({ code: 'delay', url: url, secs: checked ? 1 : 0 });
					
						$('.delay_toggle').slideToggle('fast');					
						if(checked)
							$('#delay_duration').focus();
					});
					$('#delay_duration').off('change keyup paste').on('change keyup paste', function(e)
					{
						var secs = $(this).val();
						if(secs < 1)
							secs = 1;
						else if(secs > 10)
							secs = 10;
						$(this).val(secs);				
						chrome.runtime.sendMessage({ code: 'delay', url: url, secs: secs });
					});
					if(delaySet)
					{
						$('#delay_duration').val(delay);
						$('.delay_toggle').show();
					}
					else
						$('.delay_toggle').hide();
				};
				
				
				if(selectedURL == null)
					selectedURL = urls[0];
				if(selectedURL == urls[0])
					$('.whitelist_domain:eq(0)').addClass('active');
				else
					$('.whitelist_domain:eq(1)').addClass('active');
				
				var displayNames = [
					urls[0],
					urls[1]
				];
				for(var i = 0; i < displayNames.length; i++)
					if(displayNames[i].length > 24)
						displayNames[i] = displayNames[i].substring(0, 21) + '...';
				$('.whitelist_domain:eq(0)').text(displayNames[0]);
				$('.whitelist_domain:eq(1)').text(displayNames[1]);
				$('.whitelist_domain').off('click').click(function(e)
				{
					$('.whitelist_domain').removeClass('active');
					$(this).addClass('active');
					
					var idx = $('.whitelist_domain').index(this);
					selectedURL = urls[idx];
					updateSettings(urls[idx]);
				});
				
				updateSettings(selectedURL);
			}
			else
			{
				$('.choose').remove();
				$('.force_delete').remove();
			}

			break;
	}
});

function validURL(url)
{
	return isValidURL(url) || url == getPatternAll(url);
}
function getWhitelistType(whitelist, url)
{
	url = getHost(url);
	if(typeof whitelist[url] === 'undefined')
		return false;
	return whitelist[url];
}
function thirdPartyKeep(whitelist, url)
{
	url = getHost(url);
	return typeof whitelist[url] !== 'undefined';
}
function getDelay(delays, url)
{
	var urls = [
		getHost(url)/*,
		getPatternAll(url)*/
	];
	for(var i = 0; i < urls.length; i++)
		if(typeof delays[urls[i]] !== 'undefined')
			return delays[urls[i]];
	return 0;
}
function getRootDomain(url)
{
	return getPathInfo(url).root;
}
function getHost(url)
{
	if(isPatternURL(url))
		return url;
	return getPathInfo(url).host.replace('%2A', '*');
}
function getPath(url)
{
	return getPathInfo(url).path;
}
function getPatternAll(url)
{
	return '*.' + getRootDomain(url);
}

function setKey(key, value)
{
	chrome.runtime.sendMessage({ code: 'set', key: key, value: value });
}


