document.addEventListener('DOMContentLoaded', function ()
{	
	i18n();
	
	chrome.runtime.sendMessage({ code: 'optionsCreated' });
});

chrome.runtime.onMessage.addListener(function(request, sender, sendResponse)
{
	switch(request.code)
	{
		case 'showOptions':
			var account = request.account;
			var whitelist = account.whitelist;
			
			
			$('#whitelist_add_button').off('click').click(function(e){
				addToWhitelist();
			});
			$('#whitelist_add_entry').off('keypress').keypress(function(e){
				if(e.which == 13)
					addToWhitelist();
			});
			
			var whitelistElement = $('.whitelist');
			whitelistElement.empty();
			var whitelistKeys = Object.keys(whitelist)
			var whitelistLength = whitelistKeys.length;
			if(whitelistLength > 0)
			{				
				whitelistKeys.sort(function(a, b){
					var rootA = getPathInfo(a).root.toLowerCase();
					var rootB = getPathInfo(b).root.toLowerCase();
					if(rootA < rootB)
						return -1;
					else if(rootA > rootB)
						return 1;
							
					return 0;
				});
				
				
				for(var i = 0; i < whitelistLength; i++) //(var key in whitelist)
				{
					var key = whitelistKeys[i];
						
					var url = key;
					if(!url.startsWith('http'))
						url = 'http://' + url;
					
					var value = whitelist[key];
				
					var className = value == REMOVETYPE_NEVER ? 'whitelist_type_switch bubble green-bubble' : 'whitelist_type_switch bubble yellow-bubble';
					var anchorText = key;
				
					var indicator = $('<div>', { class: className, title: i18nMessage('optionHint_whitelist_switch_type') })[0];
					var anchor = $('<a>', { href: url }).text(anchorText)[0];
					
					var entry = $('<div>', { class: 'whitelist_entry', 'data-target': key })[0];
					entry.appendChild(indicator);
					entry.appendChild(anchor);
					
					var thirdPartyLabel = $('<label>', { class: 'thirdPartySwitch_label' });
					thirdPartyLabel.text(i18nMessage('whitelist_3rdParty'));
					var thirdPartyCheckbox = $('<input>', { type: 'checkbox', class: 'thirdPartySwitch checkbox', checked: thirdPartyKeep(account.whitelist3rdParty, url) })[0];
					var thirdPartyWrap = $('<div>', { class: 'thirdPartyWrap' })[0];
					thirdPartyWrap.appendChild(thirdPartyCheckbox);
					thirdPartyWrap.appendChild(thirdPartyLabel[0]);					
					entry.appendChild(thirdPartyWrap);
					
					entry.appendChild($('<div>', { class: 'delete', title: i18nMessage('optionHint_whitelist_delete') })[0]);
					
					whitelistElement[0].appendChild(entry);
				}
				$('.delete').off('click').click(function(e){
					var url = $(this).closest('.whitelist_entry').data('target');
					chrome.runtime.sendMessage({ code: 'whitelist', url: url, type: REMOVETYPE_TAB });	
				});
				$('.whitelist_type_switch').off('click').click(function(e){
					var url = $(this).closest('.whitelist_entry').data('target');
					var type = REMOVETYPE_NEVER;
					if($(this).hasClass('green-bubble'))
						type = REMOVETYPE_WINDOW;	
					chrome.runtime.sendMessage({ code: 'whitelist', url: url, type: type });
					$(this).toggleClass('green-bubble yellow-bubble');	
				});
				$('.thirdPartySwitch').off('click').click(function(e){
					var url = $(this).closest('.whitelist_entry').data('target');
					chrome.runtime.sendMessage({ code: 'whitelist3rdParty', url: url, save: $(this).is(':checked') });	
				});
			}
			else
			{
				var wrap = $('<div>', { class: 'hint' });
				wrap.text(i18nMessage('optionHint_whitelist_empty'));
				whitelistElement[0].appendChild(wrap[0]);
			}
			
			
			$('#whitelist_export').off('click').click(function(e){
				var prefix = 'DLH';
				var filename = 'Self_Destroying_Cookies_Whitelist.restore';
				var blob = JSON.stringify([whitelist, account.whitelist3rdParty]);
				
				chrome.downloads.download({
					url: URL.createObjectURL(new Blob([ btoa(prefix + 'Q2XR8k' + btoa(blob)) ])),
					saveAs: true,
					filename: filename
				});
			});
			$('#whitelist_export').prop('disabled', whitelistLength <= 0);
			$('#whitelist_import').off('change').on('change', function(e){
				var files = e.target.files;
				var file = files[0];
				if(file)
				{
					//====detect file extension====
					var extension = file.name.split('.');
					if(extension.length >= 2)
						extension = extension[extension.length-1];
					else
						extension = '';
					//====/detect file extension====
				
					var reader = new FileReader();
					reader.onload = function(e){
						var content = e.target.result;
						var lists = [];
						var list = {};
						
						switch(extension)
						{
							case 'restore':
								lists = atob(content);
								lists = atob(lists.substring(9, lists.length));
								lists = JSON.parse(lists);
								break;
							case 'xml': // Cookie Import/Export
								/*
								<permissions>
									<exception><host>http://example.com</host><capability>9</capability></exception>
									<exception><host>http://dirtylittlehelpers.com</host><capability>8</capability></exception>
								</permissions>
								*/
								var xmlDoc = $.parseXML(content); 
								var $xml = $(xmlDoc);

								var $exceptions = $xml.find('exception');

								$exceptions.each(function(){
									var url = getHost($(this).find('host').text()),
									capability = $(this).find('capability').text();
									
									var removeType = capability == '9' ? REMOVETYPE_NEVER : REMOVETYPE_WINDOW;
									list[url] = removeType;
								});
								lists = [list, {}];
								break;
							case 'txt': // Cookie Wizard with Whitelist
								/*
								CX	http://example.com	9	(9)
								CX	http://dirtylittlehelpers.com	8	(Allow for Session)
								
								or
								
								http://example.com
								http://dirtylittlehelpers.com
								*/
								content = content.replace(/\s\s+/g, ' '); // multiple spaces, tabs, newlines -> 1 space
								content = content.replace(/\t\s*/g, ' ');
								if(content.indexOf('CX ') !== -1)
								{
									var lines = content.split('CX ');
									for(var i = 1; i < lines.length; i++)
									{
										var entry = lines[i].split(' ');
										var url = getHost(entry[0]);
										var removeType = entry[1] == '9' ? REMOVETYPE_NEVER : REMOVETYPE_WINDOW;
										list[url] = removeType;
									}
									lists = [list, {}];
								}
								else
								{
									var lines = content.split(' ');
									for(var i = 0; i < lines.length - 1; i++)
									{console.log(lines[i]);
										var url = getHost(lines[i]);
										list[url] = REMOVETYPE_NEVER;
									}
									lists = [list, {}];
								}
								break;
						}
						chrome.runtime.sendMessage({ code: 'addToWhitelist', lists: lists });
					};
					//reader.onerror = function(e){
					//};
					reader.readAsText(file, 'UTF-8');
				}
			});
			
			$('#whitelist_clear').off('click').click(function(e){
				chrome.runtime.sendMessage({ code: 'importWhitelist', lists: [{}, {}] });
			});
			
			
			$('#notify').prop('checked', account.notify);
			$('#notify').off('click').click(function(e) 
			{
				setKey('notify', $(this).is(':checked'));
			});
			$('#notify_duration').prop('value', account.notifyDuration);
			$('#notify_duration').off('change keyup paste').on('change keyup paste', function(e)
			{
				var secs = $(this).val();
				if(secs < 2)
					secs = 2;
				else if(secs > 10)
					secs = 10;
				$(this).val(secs);				
				chrome.runtime.sendMessage({ code: 'set', key: 'notifyDuration', value: secs });
			});
			
			$('#awareOpenTabs').prop('checked', account.awareOpenTabs);
			$('#awareOpenTabs').off('click').click(function(e) 
			{
				setKey('awareOpenTabs', $(this).is(':checked'));
			});
			
			$('#tabHistory').prop('checked', account.tabHistory);
			$('#tabHistory').off('click').click(function(e) 
			{
				setKey('tabHistory', $(this).is(':checked'));
			});
			
			$('#onRootChange').prop('checked', account.deleteOnRootChange);
			$('#onRootChange').off('click').click(function(e) 
			{
				setKey('deleteOnRootChange', $(this).is(':checked'));
			});
			
			var overallCookies = account.overallCookiesDeleted;
			$('.overallCount').text(overallCookies);
			$('#overallCount_reset_button').prop('disabled', overallCookies <= 0);
			$('#overallCount_reset_button').off('click').click(function(e){
				//if(confirm(i18nMessage('confirmReset')))
				//{
					chrome.runtime.sendMessage({ code: 'resetOverallCount' });
				//}	
			});
			
			break;
	}
});
function addToWhitelist()
{
	var input = $('#whitelist_add_entry');
	var url = input.val();

	if(
		//url.match(/(http(s)?:\/\/.)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/gi) ||
		isValidURL(url)  ||
		isPatternURL(url)
	)
	{
		chrome.runtime.sendMessage({ code: 'whitelist', url: url, type: REMOVETYPE_NEVER });
		input.val('');
	}
}

function thirdPartyKeep(whitelist, url)
{
	url = getHost(url);
	return typeof whitelist[url] !== 'undefined';
}
function getHost(url)
{
	if(isPatternURL(url))
		return url;
	return getPathInfo(url).host.replace('%2A', '*');
}

function setKey(key, value)
{
	chrome.runtime.sendMessage({ code: 'set', key: key, value: value });
}
  
