// CENIT FireFox ESR Anpassungen
// 2016.07.01 Version 1.0 erstellt
// 2017.12.14 Version 1.1 erstellt - uBlock Filtereinstellungen erweitert

// URI_PATH Variable ermitteln
<!--#if expr="%{REQUEST_URI} =~ m#(^/.*)(/.*\.js)#i && $1 =~ /(.+)/" -->
  <!--#set var="URI_PATH" value="$0" -->
<!--#endif -->

// Benoetigte Components hinzufuegen

Components.utils.import("resource://gre/modules/FileUtils.jsm");   
Components.utils.import("resource://gre/modules/PlacesUtils.jsm");
Components.utils.import("resource://gre/modules/Services.jsm");
Components.utils.import("resource://gre/modules/NetUtil.jsm");
Components.utils.import("resource://gre/modules/AddonManager.jsm");


// uBlock AddOn installieren
AddonManager.getInstallForURL("https://<!--#echo var="HTTP_HOST" --><!--#echo var="URI_PATH" -->/uBlock0@raymondhill.net.xpi", function(aInstall) { aInstall.install();}, "application/x-xpinstall");

// Bookmarks Klassenvariablen hinzufuegen

var navBook = Components.classes["@mozilla.org/browser/nav-bookmarks-service;1"] .getService(Components.interfaces.nsINavBookmarksService);
var ios = Components.classes["@mozilla.org/network/io-service;1"] .getService(Components.interfaces.nsIIOService);
var histSer = Components.classes["@mozilla.org/browser/nav-history-service;1"].getService(Components.interfaces.nsINavHistoryService);
var fos = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

// Bestehenden Bookmarks Ordner finden und loeschen (My Title)
var options = histSer.getNewQueryOptions();
var query = histSer.getNewQuery();
var toolbarFolder = navBook.bookmarksMenuFolder;
query.setFolders([toolbarFolder], 1);
var result = histSer.executeQuery(query, options);
var rootNode = result.root;
rootNode.containerOpen = true;
// iterate over the immediate children of this folder.
for (var i = 0; i < rootNode.childCount; i ++) {


          //alert(i);
           var node = rootNode.getChild(i);
           //alert(node.title + " "  + node.itemId);
           if (node.title == "CENIT AG") {
           var Torem = node.itemId;
           var childFolder = node.itemId;
           //alert("Folder ID = " + childFolder);
              navBook.removeItem(Torem);

} 

//else {
//alert("Folder Does Exsists and Place Holder Not There");
//}

}

//End of finding folder
// close a container after using it!
rootNode.containerOpen = false;

//Looks to see if the place holder exsists and if not adds placeholder.
var uri = ios.newURI("http://PlaceHolder.com/", null, null);
if (!navBook.isBookmarked(uri)) {
//alert("Alert LPO");
var FolderId = navBook.createFolder(navBook.bookmarksMenuFolder, "CENIT AG", 0);
var uri11 = Services.io.newURI("http://PlaceHolder.com", null, null);
//alert("Putting in URL");
navBook.insertBookmark(FolderId, uri11, 11, "Place Holder");
}


//PlaceHolder bookmark ID = BId var
//alert("Alert DFG");
var BId = navBook.getBookmarkIdsForURI(uri, {});
//alert(BId);


//FId is the returned value from the get folder ID using the bookmark ID.
//alert("Alert DRU");
try {

     var FId = navBook.getFolderIdForItem(BId);
     //alert("Alert ADM");
     } catch (e) {
       //alert("Alert FGH");
     }

//Remove Folder based on Folder Id number

try {

    navBook.removeItem(FId);
    //alert("Alert BQP");
    } catch (e) {
    //alert("Alert KGP");
    }
  
var FolderId = navBook.createFolder(navBook.bookmarksMenuFolder, "CENIT AG", 0);

//Add bookmarks
var uri1 = Services.io.newURI("http://www.cenit.com", null, null);
var uri2 = Services.io.newURI("https://secure.cenit.com", null, null);
var uri3 = Services.io.newURI("https://support.cenit.com", null, null);
var uri4 = Services.io.newURI("http://helpdesk.de.cenit-group.com", null, null);
var uri5 = Services.io.newURI("https://intranet.de.cenit-group.com", null, null);
var uri6 = Services.io.newURI("https://myhr.cenit.com", null, null);
var uri7 = Services.io.newURI("https://www.cenit.com/tkconf", null, null);
var uri8 = Services.io.newURI("https://webmail.cenit.com", null, null);
var uri9 = Services.io.newURI("https://xfer.cenit.com", null, null);
var uri10 = Services.io.newURI("https://servicestore.de.cenit-group.com", null, null);
var uri11 = Services.io.newURI("https://dokuwiki.de.cenit-group.com/doku.php?id=ito:start", null, null);
var uri12 = Services.io.newURI("https://jam12.sapjam.com/c/azl7kd5zr.accounts.ondemand.com/auth/status", null, null);

//Add bookmark to newly created folder
navBook.insertBookmark(FolderId, uri1, 0, "CENIT AG Website");
navBook.insertBookmark(FolderId, uri2, 1, "CENIT AG Secure Access");
navBook.insertBookmark(FolderId, uri3, 3, "Helpdesk (extern)");
navBook.insertBookmark(FolderId, uri4, 4, "Helpdesk (intern)");
navBook.insertBookmark(FolderId, uri5, 5, "Intranet (intern)");
navBook.insertBookmark(FolderId, uri6, 6, "MyHR (intern)");
navBook.insertBookmark(FolderId, uri7, 7, "Telefonkonferenzserver");
navBook.insertBookmark(FolderId, uri8, 8, "Webmail");
navBook.insertBookmark(FolderId, uri9, 9, "XFER");
navBook.insertBookmark(FolderId, uri10, 10, "ServiceStore");
navBook.insertBookmark(FolderId, uri11, 11, "ITO Tipps");
navBook.insertBookmark(FolderId, uri12, 12, "CENIT ONE");

// Userchrome und Usercontent Dateien schreiben

var profileDir = Services.dirsvc.get("ProfD", Components.interfaces.nsILocalFile);
profileDir.append("chrome");

if( !profileDir.exists() || !profileDir.isDirectory() ) {
 profileDir.create(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0777);
};

profileDir.append("userChrome.css");
fos.init(profileDir, -1, -1, false);
var css1 = "#PanelUI-customize {visibility:collapse!important;}\r\nmenu[label=\x22Tools\x22] menuitem[label=\x22Sync Now\x22],#PanelUI-footer-fxa,#toolbar-context-menu,#sync-setup-appmenu,#sync-button,#sync-syncnowitem-appmenu,#PanelUI-fxa-status,#sync-setup,#sync-status-button,#BrowserPreferences radio[pane=\x22paneSync\x22] {display:none!important;}";
fos.write(css1, css1.length);
fos.close();

var profileDir = Services.dirsvc.get("ProfD", Components.interfaces.nsILocalFile);
profileDir.append("chrome");
profileDir.append("userContent.css");


fos.init(profileDir, -1, -1, false);
var css10 = "#category-sync {display:none !important;}";
fos.write(css10, css10.length);
fos.close();

try {

function importExceptions(Exception) {
  var uri = Services.io.newURI([Exception], null, null);
  Services.perms.add(uri, "popup", 1);
  Services.perms.add(uri, "cookie", 1);
  Services.perms.add(uri, "plugins", 1);
  // Services.perms.add(uri, "install", 1);
}

importExceptions("http://www.cenit.com");
importExceptions("http://www.cenit.de");

importExceptions("https://www.cenit.de");
importExceptions("https://extranet.cenit.de");

importExceptions("https://www.cenit.com");
importExceptions("https://alo5.cenit.com");
importExceptions("https://myhr.cenit.com");
importExceptions("https://secure.cenit.com");
importExceptions("https://support.cenit.com");
importExceptions("https://webmail.cenit.com");
importExceptions("https://xfer.cenit.com");

importExceptions("http://intranet.de.cenit-group.com");
importExceptions("http://helpdesk.de.cenit-group.com");

importExceptions("https://intranet.de.cenit-group.com");

importExceptions("https://servicestore.de.cenit-group.com");

} catch(e) {
Components.utils.reportError(e);
};

// Plugins im Browser anzeigen
clearPref("plugin.disable_full_page_plugin_for_types");

// Auto Update deaktivieren
lockPref("app.update.enabled", false);
lockPref("app.update.auto", false);
lockPref("app.update.mode", 0);
lockPref("app.update.service.enabled", false);

// Extensions Auto Update deaktivieren
lockPref("extensions.update.enabled", false);

// Deaktiviert die Kompatbilitätsprüfung der Add-ons
clearPref("extensions.lastAppVersion"); 

//Deaktiviert das Plugin Checking
lockPref("plugins.hide_infobar_for_outdated_plugin", true);
clearPref("plugins.update.url");

// Do Not Track senden
lockPref("privacy.donottrackheader.enabled", true);
lockPref("Privacy.donottrackheader.value", 1);

// Abfrage fuer FireFox als Standardbrowser deaktivieren
lockPref("browser.shell.checkDefaultBrowser", false);
lockPref("pref.general.disable_button.default_browser", true);

// Internetauftritt als Startseite - Über Softwarepaket als Vorschlag
// lockPref("browser.startup.homepage", "http://www.cenit.com");
// lockPref("browser.startup.page", 1);

// Was ist neu ausblenden
lockPref("browser.startup.homepage_override.mstone","ignore");

// Lernen Sie ihre Rechte kennen ausblenden
lockPref("browser.rights.3.shown", true);

// Willkommen Seite ausblenden
lockPref("noWelcomePage", true);

// Health Reporter deaktivieren
lockPref("datareporting.healthreport.service.enabled", false);
lockPref("datareporting.healthreport.uploadEnabled", false); 

// Datenupload (Telemetry/FHR) zu Mozilla deaktivieren
lockPref("datareporting.policy.dataSubmissionEnabled", false);

// Absturzmeldungen deaktivieren
lockPref("toolkit.crashreporter.enabled", false);
Components.classes["@mozilla.org/toolkit/crash-reporter;1"].getService(Components.interfaces.nsICrashReporter).submitReports = false;

// Firefox Smart & Standard Bookmarks entfernen
lockPref("removeSmartBookmarks", true);
lockPref("removeDefaultBookmarks", true);

// Webseiten teilen deaktivieren
lockPref("disableSharePage", true);

// Reset von Firefox verhindern
lockPref("disableResetFirefox", true);

// Google als Standardsuche
pref("browser.search.order.1", "Google");

// Deaktiviert den internen PDF-Viewer
pref("pdfjs.disabled", true);

// Sync Funktion deaktivieren
lockPref("services.sync.enabled", false);
lockPref("browser.migrated-sync-button", false);

lockPref("services.sync.serverURL", "");
lockPref("services.sync.clusterURL", "");
lockPref("services.sync.jpake.serverURL", "");

// Netzwerkproxy sperren
pref("network.proxy.type", 5);

// Entfernte DNS abfrage sperren
lockPref("network.proxy.socks_remote_dns", false);

// Download Dir nicht verwenden
lockPref("browser.download.useDownloadDir", false);

// Hello / WebRTC deaktivieren
lockPref("loop.enabled", false);
lockPref("media.peerconnection.enabled", false);

// Pocket deaktivieren
lockPref("browser.pocket.enabled", false);
lockPref("extensions.pocket.enabled", false);

// Heartbeat deaktivieren
lockPref("browser.selfsupport.url", "https://www.cenit.com");

// Snippets deaktivieren
lockPref("browser.aboutHomeSnippets.updateUrl", "");

// Pocket deaktivieren
lockPref("browser.newtabpage.enabled", false);

// Beacon deaktivieren 
lockPref("beacon.enabled", true);

lockPref("browser.search.geoip.timeout", 1);
lockPref("geo.enabled", false);
lockPref("geo.wifi.uri", "");

lockPref("devtools.webide.autoinstallADBHelper", false);
lockPref("devtools.webide.autoinstallFxdtAdapters", false);
lockPref("devtools.webide.enabled", false);

lockPref("dom.enable_performance", false);
lockPref("dom.enable_resource_timing", false);
lockPref("dom.enable_user_timing", false);

lockPref("extensions.installDistroAddons", true);
lockPref("extensions.enabledScopes", 15);
lockPref("extensions.autoDisableScopes", 0);
lockPref("extensions.shownSelectionUI", true);

lockPref("extensions.getAddons.cache.enabled", false);
lockPref("network.http.speculative-parallel-limit", 0);
lockPref("security.tls.version.min", 1);

// Windows Zertifikatstore benutzen
lockPref("security.enterprise_roots.enabled", true);


// uBlock Einstellungen
lockPref("extensions.ublock0.adminSettings","{\"timeStamp\":1513183043901,\"version\":\"1.14.20\",\"userSettings\":{\"advancedUserEnabled\":false,\"alwaysDetachLogger\":false,\"autoUpdate\":true,\"cloudStorageEnabled\":false,\"collapseBlocked\":true,\"colorBlindFriendly\":false,\"contextMenuEnabled\":true,\"dynamicFilteringEnabled\":false,\"externalLists\":[],\"firewallPaneMinimized\":true,\"hyperlinkAuditingDisabled\":true,\"ignoreGenericCosmeticFilters\":false,\"largeMediaSize\":50,\"parseAllABPHideFilters\":true,\"prefetchingDisabled\":true,\"requestLogMaxEntries\":1000,\"showIconBadge\":true,\"tooltipsDisabled\":false,\"webrtcIPAddressHidden\":false},\"selectedFilterLists\":[\"user-filters\",\"assets.json\",\"public_suffix_list.dat\",\"ublock-resources\",\"ublock-filters\",\"ublock-badware\",\"ublock-privacy\",\"ublock-abuse\",\"ublock-unbreak\",\"easylist\",\"easyprivacy\",\"malware-0\",\"malware-1\",\"plowe-0\",\"DEU-0\"],\"hiddenSettingsString\":\"assetFetchTimeout 30\\nautoUpdateAssetFetchPeriod 120\\nautoUpdatePeriod 7\\nignoreRedirectFilters false\\nignoreScriptInjectFilters false\\nmanualUpdateAssetFetchPeriod 2000\\npopupFontSize unset\\nsuspendTabsUntilReady false\\nuserResourcesLocation unset\",\"netWhitelist\":\"cenit.com\\nde.cenit-group.com\",\"dynamicFilteringString\":\"behind-the-scene * 3p-frame noop\\nbehind-the-scene * 3p noop\",\"urlFilteringString\":\"\",\"hostnameSwitchesString\":\"\",\"userFilters\":\"\",\"filterLists\":{\"assets/user/filters.txt\":{\"off\":false},\"assets.json\":{\"off\":false},\"assets/thirdparties/publicsuffix.org/list/effective_tld_names.dat\":{\"off\":false},\"assets/ublock/resources.txt\":{\"off\":false},\"assets/ublock/filters.txt\":{\"off\":false},\"assets/ublock/badware.txt\":{\"off\":false},\"assets/ublock/privacy.txt\":{\"off\":false},\"ublock-abuse\":{\"off\":false},\"assets/ublock/unbreak.txt\":{\"off\":false},\"assets/thirdparties/easylist-downloads.adblockplus.org/easylist.txt\":{\"off\":false},\"assets/thirdparties/easylist-downloads.adblockplus.org/easyprivacy.txt\":{\"off\":false},\"assets/thirdparties/www.malwaredomainlist.com/hostslist/hosts.txt\":{\"off\":false},\"assets/thirdparties/mirror1.malwaredomains.com/files/justdomains\":{\"off\":false},\"assets/thirdparties/pgl.yoyo.org/as/serverlist\":{\"off\":false},\"https://easylist-downloads.adblockplus.org/easylistgermany.txt\":{\"off\":false},\"assets/ublock/experimental.txt\":{\"off\":true}}}");