﻿/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Profile Manager and Selector (pmOverlay.js).
 *
 * The Initial Developer of the Original Code is Weidong Lu.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Weidong Lu <lwd.firefox@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var profileService =  Components.classes["@mozilla.org/toolkit/profile-service;1"]
                     .getService(Components.interfaces.nsIToolkitProfileService); 
                     
var pmOptions = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("profilemanager.");
var firstRun = pmOptions.getIntPref("opt_firstRun");


function pm_init(){
   try{
    var profd = Components.classes["@mozilla.org/file/directory_service;1"]
                        .getService(Components.interfaces.nsIProperties)
                        .get("ProfD", Components.interfaces.nsILocalFile);
                        
    try {  //add button to the default 
        var firefoxnav = document.getElementById("nav-bar");
        var curSet = firefoxnav.currentSet;
        if (curSet.indexOf("pm_button") == -1)
        {
            var set;
            // Place the button before the urlbar
            if (curSet.indexOf("urlbar-container") != -1)
            set = curSet.replace(/urlbar-container/, "pm_button,urlbar-container");
            else  // at the end
            set = firefoxnav.currentSet + ",pm_button";
            
            firefoxnav.setAttribute("currentset", set);
            firefoxnav.currentSet = set;
            document.persist("nav-bar", "currentset");
            // If you don't do the following call, funny things happen
            try {
                BrowserToolboxCustomizeDone(true);
            }
            catch (e) { }
        }
    }
    catch(e) { }    
    
    if (pmOptions.getIntPref("opt_showToolbarButton") == 0){
        document.getElementById("pm_button").setAttribute("hidden", true);
    } else document.getElementById("pm_button").setAttribute("hidden", false);
    
    var profileArray = pm_parseProfileINI();
    var currentProfileName = profileArray[0][profileArray[1].indexOf(profd.path)];
    
    if (firstRun == 1) {
        try{            
            pmOptions.setIntPref("opt_firstRun", 0);
            
            if (currentProfileName != null){
                pmOptions.setCharPref("opt_defaultProfileName", currentProfileName);
            } else {
                var profileINI = "\r\n[Profile"+profileArray[0].length+"]\r\n";
                if (profileArray[0].indexOf("default") == -1) {
                    profileINI = profileINI + "Name=default\r\n";
                    pmOptions.setCharPref("opt_defaultProfileName", "default");
                }
                else {
                    profileINI = profileINI + "Name=PortableFx\r\n";
                    pmOptions.setCharPref("opt_defaultProfileName", "PortableFx");
                }
                profileINI = profileINI + "IsRelative=0\r\n";
                profileINI = profileINI + "Path="+profd.path+"\r\n";
                pm_writeProfileINI(profileINI, "append");
                restartApp(false);
                return false;
            }
        }catch(e){
            //alert(e);
            //alert("Error: cannot find profile.ini. Either the Firefox is not correctly installed or a portable version of Firefox is currently being used.");
            //return false;
        }
    } // end of if firstRun
     
    if ((pmOptions.getIntPref("opt_syncOnStartup") == 1) && (pmOptions.getCharPref("opt_lastSyncOperation") != "download")) pm_synchronizeProfile("sync");
    // set it back from download because the restart process caused by downloading an updated profile has finished. 
    if (pmOptions.getCharPref("opt_lastSyncOperation") == "download") {
        var remoteProfilePath = pmOptions.getCharPref("opt_rProfilePath");
        var localProfilePath = pmOptions.getCharPref("opt_lProfilePath");
        pm_syncDir(remoteProfilePath, localProfilePath, "COPY_EXTRA", 1);
        pm_syncDir(localProfilePath, remoteProfilePath, "DEL_EXTRA", 1);       
        pmOptions.setCharPref("opt_lastSyncOperation", "")
        restartApp();
    }
    var pmStatusbar = document.getElementById("pm-status-panel");
    var pmProfileName = document.getElementById("pm_profileName");
    
    if (pmOptions.getIntPref("opt_showStatusbarButton") == 1) {
        pmStatusbar.setAttribute("hidden", false);
        if (currentProfileName != null)
        pmProfileName.setAttribute("value", currentProfileName);
        else  pmProfileName.setAttribute("value", "Portable");
        
        if (pmOptions.getIntPref("opt_showProfileName") == 1) {
            pmProfileName.setAttribute("hidden", false);
        } else pmProfileName.setAttribute("hidden", true);
    }
    else pmStatusbar.setAttribute("hidden", true);
    
    if (pmOptions.getIntPref("opt_syncAutomatic") == 1){                   
        var minutes = pmOptions.getIntPref("opt_syncAutoInterval");
        if (minutes > 0) {
            setTimeout(pm_syncAutomatic, minutes*60*1000);
        }
    }
    }catch(e){alert(e);}

    //add listener to the context menu so that "Open Link in New Profile" shows on right click a link. 
    var menu = document.getElementById('contentAreaContextMenu');
    menu.addEventListener("popupshowing", showOpenInNewProfileMenu, false);
}

// show popup menu items in bookmark context menu
function showBookmarkContextMenu(){
    if (pmOptions.getIntPref("opt_showOpenLink") != 0) {
        document.getElementById("pm_showBookmarkOpenLink").hidden = false;
        pm_showProfileList("pm_bookmarkOpenLink", document.popupNode.node.uri);
    } else document.getElementById("pm_showBookmarkOpenLink").hidden = true;
 
}

function showOpenInNewProfileMenu() {
    
	if (gContextMenu) {
		var isOpenableLink = ( gContextMenu.onSaveableLink ||
                                      ( gContextMenu.inDirList && gContextMenu.onLink ) );
                
                if ((gContextMenu.onLink) && (pmOptions.getIntPref("opt_showOpenLink") != 0)){
                    document.getElementById("pm_showOpenLink").hidden = false;
                    document.getElementById("pm_showOpenPage").hidden = true;
                    pm_showProfileList("pm_openLink", document.popupNode.href);
                } else {
                    document.getElementById("pm_showOpenLink").hidden = true; //hide openLink menu
                    
                    if ((pmOptions.getIntPref("opt_showOpenPage") != 0)){
                        document.getElementById("pm_showOpenPage").hidden = false; // show openPage menu
                        pm_showProfileList("pm_openPage", gBrowser.selectedBrowser.currentURI.spec);
                    }else {
                        document.getElementById("pm_showOpenPage").hidden = true; // hide openPage menu
                    }
                }
	}
}



function pm_syncAutomatic(){ 
    
    if (pmOptions.getIntPref("opt_syncAutomatic") == 1){                   
        var minutes = pmOptions.getIntPref("opt_syncAutoInterval");
        if (minutes > 0) {
            pm_synchronizeProfile("sync");
            setTimeout(pm_syncAutomatic, minutes*60*1000);
        }
    }
}

function pm_unload(){
    
    if (pmOptions.getIntPref("opt_noDefaultProfile") == 0){
        var profileINIArray = pm_parseProfileINI();
        
        var profileINI = "[General]\r\nStartWithLastProfile=1\r\n\r\n";
        var default_flag = false;
        
        for (i = 0; i < profileINIArray[0].length; i++){
            profileINI = profileINI + "[Profile"+ i +"]\r\n"+"Name=" + profileINIArray[0][i] + "\r\n"+"IsRelative=0\r\n"+"Path="+ profileINIArray[1][i]+"\r\n";
            if (profileINIArray[0][i] == pmOptions.getCharPref("opt_defaultProfileName")) {
                profileINI = profileINI + "Default=1\r\n";
                default_flag = true;
            }
            profileINI = profileINI + "\r\n";
        }
        
        pm_writeProfileINI(profileINI, "overwrite");
        if (!default_flag) alert("Das von Ihnen gewählte Standard Profil wurde nicht in der Profil Liste gefunden. Bitte beim nächsten Start das Standard Profil zurück setzen - neu einstellen.");
    }
    
    if ((pmOptions.getIntPref("opt_syncOnShutdown") == 1) && (pmOptions.getCharPref("opt_lastSyncOperation") != "download")) pm_synchronizeProfile("sync");
    
}

function pm_callProfileManager(){
    
        var installPath = Components.classes["@mozilla.org/file/directory_service;1"]
                                        .getService(Components.interfaces.nsIProperties)
                                        .get("CurProcD", Components.interfaces.nsIFile);
                                        
        var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                                    .getService(Components.interfaces.nsIXULAppInfo)
                                    .QueryInterface(Components.interfaces.nsIXULRuntime);
                                    
        if (installPath != null) {
            
            if (appInfo.OS == "WINNT"){      
                installPath.append("firefox.exe");
            }
            else {
                installPath.append("firefox");
            } 
            
            var pmProcess = Components.classes["@mozilla.org/process/util;1"].getService(Components.interfaces.nsIProcess);
            try{
                pmProcess.init(installPath);
                }catch(e){;}
            pmArgs = ["-P", "-no-remote"];
            pmProcess.run(false, pmArgs, pmArgs.length); 
        }
        else {
            alert("Fehler: Es wurde keine Mozilla Firefox Installation gefunden. ");
        }    
}

function pm_runProfile(profileName, newTabURL){
    
        var installPath = Components.classes["@mozilla.org/file/directory_service;1"]
                                        .getService(Components.interfaces.nsIProperties)
                                        .get("CurProcD", Components.interfaces.nsIFile);
                                        
        var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                                    .getService(Components.interfaces.nsIXULAppInfo)
                                    .QueryInterface(Components.interfaces.nsIXULRuntime);
                                    
        var pmArgs = ["-P", "-no-remote", profileName];
                                    
        if (installPath != null) {
            
            if (appInfo.OS == "WINNT"){      
                installPath.append("firefox.exe");
            }
            else {
                installPath.append("firefox");
            } 
            
            var pmProcess = Components.classes["@mozilla.org/process/util;1"].getService(Components.interfaces.nsIProcess);
            
            try{
                pmProcess.init(installPath);
            }catch(e){;}
            
            try{            

                if ((newTabURL != null ) && (newTabURL != "null")){                     
                    pmArgs = ["-P", "-no-remote", profileName, "-new-tab", newTabURL];
                    
                } else if (document.getElementById("pm_TabRestore").checked == true){// open the current tab in new profile is selected from the statusbar
                    
                    pmArgs = ["-P", "-no-remote", profileName, "-new-tab", gBrowser.selectedBrowser.currentURI.spec];
                
                } else if ((document.getElementById("pm_sessionRestore").checked == true)){// open all tabs in new profile is selected from the statusbar
                    var profileINIArray = pm_parseProfileINI();
                    var newProfilePath = profileINIArray[1][profileINIArray[0].indexOf(profileName)];
                    var profd = Components.classes["@mozilla.org/file/directory_service;1"]
                                .getService(Components.interfaces.nsIProperties)
                                .get("ProfD", Components.interfaces.nsILocalFile);
                    var sessionFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                    sessionFile.initWithPath(profd.path);
                    sessionFile.append("sessionstore.js");
                    var tmpFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                    tmpFile.initWithPath(newProfilePath);
                    tmpFile.append("sessionstore.js");
                    
                    if (tmpFile.exists()){
                        tmpFile.remove(false);
                    }
                    //copy the sessionstore file to the newly selected profile folder.
                    sessionFile.copyTo(tmpFile.parent, "sessionstore.js");
                    
                    
                }
                
                pmProcess.run(false, pmArgs, pmArgs.length); 
                
                
            }catch(e){alert(e);}
            

            
        }
        else {
            alert("Fehler: Es wurde keine Mozilla Firefox Installation gefunden. ");
        }    
        
        // obsolted code for tab restore
        //var tmpFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
                    //tmpFile.initWithPath(newProfilePath);
                    //tmpFile.append("sessionstore.js");
                    
                    //var ss = Components.classes["@mozilla.org/browser/sessionstore;1"].
                    //         getService(Components.interfaces.nsISessionStore);
                    
                    //var textToWrite = "({windows:[{tabs:[" + ss.getTabState(currentTab) + "]}]})"; 
                    
                    //var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
                    //               .createInstance(Components.interfaces.nsIFileOutputStream);
                         
                    //foStream.init(tmpFile, 0x02 | 0x08 | 0x20, 0600, 0); // write, create, truncate
    
                    //foStream.write(textToWrite, textToWrite.length);
                    //foStream.close();
}


function pm_showProfileList(menuID, newTabURL){
    // menuID = pm_openLink, pm_openPage, pm_statusContext    
    //document.getElementById("pm_statusContext").collapsed = false;
    
    var profileINIArray = pm_parseProfileINI();
    var popMenu = document.getElementById(menuID);
    pm_removeAllChilds(popMenu);
    
    var menuitem;
    
    for (i = 0; i < profileINIArray[0].length; i++){
        menuitem = popMenu.appendChild(document.createElement("menuitem"));
        menuitem.setAttribute("id", profileINIArray[0][i]);
        menuitem.setAttribute("label", profileINIArray[0][i]);
        menuitem.setAttribute("onclick", "pm_runProfile(this.id, '"+newTabURL+"')");
    }
    
    if (menuID == "pm_statusContext"){
        menuitem = popMenu.appendChild(document.createElement("checkbox"));
        menuitem.setAttribute("id", "pm_sessionRestore");
        menuitem.setAttribute("label", "Alle Tabs in neuem Profil öffnen");
        
        menuitem = popMenu.appendChild(document.createElement("checkbox"));
        menuitem.setAttribute("id", "pm_TabRestore");
        menuitem.setAttribute("label", "Aktuellen Tab in neuem Profil öffnen");
        
        menuitem = popMenu.appendChild(document.createElement("menuseparator"));
        
        menuitem = popMenu.appendChild(document.createElement("menuitem"));
        menuitem.setAttribute("id", "pm_statusSync");
        menuitem.setAttribute("label", "Jetzt Synchronisieren");
        menuitem.setAttribute("onclick", "pm_synchronizeProfile('sync');");
        
        menuitem = popMenu.appendChild(document.createElement("menuitem"));
        menuitem.setAttribute("id", "pm_goToOptions");
        menuitem.setAttribute("label", "Optionen...");
        menuitem.setAttribute("onclick", "pm_gotoOptions();");
    }
}

function pm_removeAllChilds(element){

    while (element.hasChildNodes()){
        element.removeChild(element.firstChild);
    }
}

function pm_gotoOptions(){
    window.openDialog("chrome://profilemanager/content/pmOptions.xul","pmOptionsDialog", "chrome,titlebar,resizable=yes", window);		
}

function pm_statusbarCallProfileManager(e){

    if (e.button == 0) {
        pm_callProfileManager();
    }
}
