'use strict';

let EYTD={

packageName: 'easyvideodownloader',
safeWin: null,
target: null,

dataStorage: function () { // GM_getValue, GM_setValue
  this.pref = Components.classes['@mozilla.org/preferences-service;1'].
    getService(Components.interfaces.nsIPrefService).
    getBranch('extensions.'+EYTD.packageName+'.');    
  this.getValue = function(prefName, defaultValue) {
    let prefType = this.pref.getPrefType(prefName);
    return (prefType == this.pref.PREF_STRING)?this.pref.getCharPref(prefName):defaultValue;
  }
  this.setValue = function(prefName, value) {
    if (typeof value == 'string') {
      sendAsyncMessage(EYTD.packageName+':setvalue', {pref:prefName,value:value});
    }
  }  
},

crossXHR: function (unsafeContentWin) { // GM_xmlhttpRequest
  this.unsafeContentWin = unsafeContentWin;
  this.contentStartRequest = function(details) {
    if (Components.utils.waiveXrays) { // bypass xrays protection Firefox 32+
      details = Components.utils.waiveXrays(details);
    }    
    let url = details.url;
    if (typeof url != 'string' || !/^https?:\/\//.test(url)) {
      throw new Error('crossXHR: Invalid url '+url);
    }
    new XPCNativeWrapper(unsafeContentWin, 'setTimeout()')
    .setTimeout(EYTD.hitch(this, 'chromeStartRequest', details), 0);
  }
  this.chromeStartRequest = function(details) {
    let req = Components.classes['@mozilla.org/xmlextras/xmlhttprequest;1']
    .createInstance(Components.interfaces.nsIXMLHttpRequest);
    this.setupRequestEvent(this.unsafeContentWin, req, 'load', details);
    this.setupRequestEvent(this.unsafeContentWin, req, 'error', details);
    this.setupRequestEvent(this.unsafeContentWin, req, 'readystatechange', details);
    req.open(details.method, details.url);
    req.send(details.data);
  }
  this.setupRequestEvent = function(unsafeContentWin, req, event, details) {
    if (!details['on' + event]) return; 
    req.addEventListener(event, function(evt) {
       let responseState = {
          __exposedProps__: {readyState:'r',responseText:'r',
          responseHeaders:'r',status:'r',statusText:'r'},       
          responseText: req.responseText,
          responseHeaders: req.getAllResponseHeaders(),
          readyState: req.readyState,
          status: (req.readyState==4)?req.status:0,
          statusText: (req.readyState==4)?req.statusText:''
        };
        let state = responseState;
        if (typeof Components.utils.cloneInto == 'function') {
          state = Components.utils.cloneInto(responseState,unsafeContentWin);
        }
        new XPCNativeWrapper(unsafeContentWin, 'setTimeout()')
          .setTimeout(function(){ details['on' + event](state); }, 0);
    }, false);
  }  
},
  
hitch: function (obj, method) {
  if (obj && method && (typeof method == 'string')) {
    if (!obj[method]) {
      throw 'Hitch: '+obj+'.'+method+' does not exist';
    }
    method = obj[method];
  } else if (typeof method == 'function') {
    obj = obj || {};
  } else {
    throw 'Hitch: Invalid arguments';
  }
  let staticArgs = Array.prototype.splice.call(arguments, 2, arguments.length);
  return function() {
    let args = Array.prototype.slice.call(staticArgs);
    Array.prototype.push.apply(args, arguments);
    return method.apply(obj, args);
  };
},

downloadFile: function(url, filename) {
    sendAsyncMessage(EYTD.packageName+':savefileas', 
    {url:url,filename:filename}, {target:EYTD.target});
},

getUrlContents: function(url) {
    let	ioService = Components.classes['@mozilla.org/network/io-service;1']
    .getService(Components.interfaces.nsIIOService);
    let	scriptableStream = Components
    .classes['@mozilla.org/scriptableinputstream;1']
    .getService(Components.interfaces.nsIScriptableInputStream);
    let unicodeConverter = Components
    .classes['@mozilla.org/intl/scriptableunicodeconverter']
    .createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
    unicodeConverter.charset = 'UTF-8';
    let	input = ioService.newChannel(url, 'UTF-8', null).open();
    scriptableStream.init(input);
    let	str = scriptableStream.read(input.available());
    scriptableStream.close();
    input.close();
    try {
      return unicodeConverter.ConvertToUnicode(str);
    } catch (e) {
      return str;
    }
},

contentLoad: function(e) {
    EYTD.target = e.target;
    let unsafeWin = e.target.defaultView;
    if (unsafeWin.wrappedJSObject) {
      unsafeWin = unsafeWin.wrappedJSObject;
    }
    if (unsafeWin.frameElement) { // ignore frames
      return;
    }      
    let unsafeLoc = new XPCNativeWrapper(unsafeWin, 'location').location;
    let href = new XPCNativeWrapper(unsafeLoc, 'href').href;
    let scheme = Components.classes['@mozilla.org/network/io-service;1']
    .getService(Components.interfaces.nsIIOService).extractScheme(href);   
    if ((scheme == 'http' || scheme == 'https') && 
    /^https?:\/\/www\.youtube\.com\//.test(href) && 
    !/^https?:\/\/www\.youtube\.com\/embed\//.test(href)) { // inject script
      let safeWin = new XPCNativeWrapper(unsafeWin);
      EYTD.safeWin = e.target.defaultView;
      let sandbox = new Components.utils.Sandbox(safeWin, 
      {'sandboxPrototype':safeWin, 'wantXrays':true});
      var unsafeWindowGetter = new sandbox.Function('return window.wrappedJSObject || window;');
      Object.defineProperty(sandbox, 'unsafeWindow', {get: unsafeWindowGetter});
      let storage = new EYTD.dataStorage();
      sandbox.GM_getValue = EYTD.hitch(storage, 'getValue');
      sandbox.GM_setValue = EYTD.hitch(storage, 'setValue');
      let xmlhttpRequester = new EYTD.crossXHR(unsafeWin);
      sandbox.GM_xmlhttpRequest = EYTD.hitch(xmlhttpRequester, 'contentStartRequest');      
      sandbox.GM_download = EYTD.downloadFile;
      try {
          let script = EYTD.getUrlContents(
          'resource://'+EYTD.packageName+'/content/content.js');
          Components.utils.evalInSandbox(script, sandbox);
      } catch (e) { }
    }       
},

inject: function(event) {
  let doc = event.originalTarget;
  if (doc.nodeName != '#document') return; // only documents 
  EYTD.contentLoad(event);
},

init: function() {
  addEventListener('DOMContentLoaded', EYTD.inject);
},

uninit: function() {
  removeEventListener('DOMContentLoaded', EYTD.inject);
}

}

// addMessageListener(EYTD.packageName+':init', EYTD.init);
// addMessageListener(EYTD.packageName+':uninit', EYTD.uninit);

addEventListener('DOMContentLoaded', EYTD.inject);