﻿// ==UserScript==
// @name Easy Youtube Video Downloader Express
// @description Adds options to download YouTube videos in various formats
// @homepageURL  http://www.yourvideofile.com
// @namespace eytd
// @include http://www.youtube.com/*
// @include https://www.youtube.com/*
// @exclude http://www.youtube.com/embed/*
// @exclude https://www.youtube.com/embed/*
// @match http://www.youtube.com/*
// @match https://www.youtube.com/*
// @match http://s.ytimg.com/yts/jsbin/html5player*
// @match https://s.ytimg.com/yts/jsbin/html5player*
// @match http://manifest.googlevideo.com/*
// @match https://manifest.googlevideo.com/*
// @match http://*.googlevideo.com/videoplayback*
// @match https://*.googlevideo.com/videoplayback*
// @match http://*.youtube.com/videoplayback*
// @match https://*.youtube.com/videoplayback*
// @grant GM_xmlhttpRequest
// @grant GM_getValue
// @grant GM_setValue
// @run-at document-end
// ==/UserScript==

(function () {
	var FORMAT_LABEL = {
		'5' : 'FLV 240p',
		'17' : '3GP 144p',
		'36' : '3GP 240p',
		'18' : 'MP4 360p',
		'22' : 'MP4 720p',
		'34' : 'FLV 360p',
		'35' : 'FLV 480p',
		'37' : 'MP4 1080p',
		'38' : 'MP4 2160p',
		'43' : 'WebM 360p',
		'44' : 'WebM 480p',
		'45' : 'WebM 720p',
		'46' : 'WebM 1080p',
		'135' : 'MP4 480p - no audio',
		'137' : 'MP4 1080p - no audio',
		'138' : 'MP4 2160p - no audio',
		'139' : 'M4A 48kbps - audio',
		'140' : 'M4A 128kbps - audio',
		'141' : 'M4A 256kbps - audio',
		'264' : 'MP4 1440p - no audio',
		'266' : 'MP4 2160p - no audio',
		'298' : 'MP4 720p60 - no audio',
		'299' : 'MP4 1080p60 - no audio'
	};
	var FORMAT_TYPE = {
		'5' : 'flv',
		'17' : '3gp',
		'36' : '3gp',
		'18' : 'mp4',
		'22' : 'mp4',
		'34' : 'flv',
		'35' : 'flv',
		'37' : 'mp4',
		'38' : 'mp4',
		'43' : 'webm',
		'44' : 'webm',
		'45' : 'webm',
		'46' : 'webm',
		'135' : 'mp4',
		'137' : 'mp4',
		'138' : 'mp4',
		'139' : 'm4a',
		'140' : 'm4a',
		'141' : 'm4a',
		'264' : 'mp4',
		'266' : 'mp4',
		'298' : 'mp4',
		'299' : 'mp4'
	};
	var FORMAT_ORDER = ['5', '17', '36', '18', '34', '43', '35', '135', '44', '22', '298', '45', '37', '299', '46', '264', '38', '266', '139', '140', '141'];
	var FORMAT_RULE = {
		'flv' : 'max',
		'3gp' : 'max',
		'mp4' : 'all',
		'webm' : 'none',
		'm4a' : 'max'
	};
	// all=display all versions, max=only highest quality version, none=no version
	// the default settings show all MP4 videos, the highest quality FLV and no WebM
	var SHOW_DASH_FORMATS = false;
	var BUTTON_TEXT = {
		'ar' : 'تنزيل',
		'cs' : 'Stáhnout',
		'de' : 'Herunterladen',
		'en' : 'Download As',
		'es' : 'Descargar',
		'fr' : 'Télécharger',
		'hi' : 'डाउनलोड',
		'hu' : 'Letöltés',
		'id' : 'Unduh',
		'it' : 'Scarica',
		'ja' : 'ダウンロード',
		'ko' : '내려받기',
		'pl' : 'Pobierz',
		'pt' : 'Baixar',
		'ro' : 'Descărcați',
		'ru' : 'Скачать',
		'tr' : 'İndir',
		'zh' : '下载',
		'zh-TW' : "下載"
	};
	var BUTTON_TOOLTIP = {
		'ar' : 'تنزيل هذا الفيديو',
		'cs' : 'Stáhnout toto video',
		'de' : 'Dieses Video herunterladen',
		'en' : 'Download this video',
		'es' : 'Descargar este vídeo',
		'fr' : 'Télécharger cette vidéo',
		'hi' : 'वीडियो डाउनलोड करें',
		'hu' : 'Videó letöltése',
		'id' : 'Unduh video ini',
		'it' : 'Scarica questo video',
		'ja' : 'このビデオをダウンロードする',
		'ko' : '이 비디오를 내려받기',
		'pl' : 'Pobierz plik wideo',
		'pt' : 'Baixar este vídeo',
		'ro' : 'Descărcați acest videoclip',
		'ru' : 'Скачать это видео',
		'tr' : 'Bu videoyu indir',
		'zh' : '下载此视频',
		'zh-TW' : "下載此影片"
	};
	var DECODE_RULE = [];
	var RANDOM = '-eytd';
	var CONTAINER_ID = 'download-youtube-video' + RANDOM;
	var LISTITEM_ID = 'download-youtube-video-fmt' + RANDOM;
	var BUTTON_ID = 'download-youtube-video-button' + RANDOM;
	var DEBUG_ID = 'download-youtube-video-debug-info';
	var STORAGE_URL = 'download-youtube-script-url';
	var STORAGE_CODE = 'download-youtube-signature-code';
	var STORAGE_DASH = 'download-youtube-dash-enabled';
	var isDecodeRuleUpdated = false;
	version = 9.02;

	start();

	function start() {
		var pagecontainer = document.getElementById('page-container');
		if (!pagecontainer)
			return;
		if (/^https?:\/\/www\.youtube.com\/watch\?/.test(window.location.href))
			run();
		var isAjax = /class[\w\s"'-=]+spf\-link/.test(pagecontainer.innerHTML);
		var logocontainer = document.getElementById('logo-container');
		if (logocontainer && !isAjax) { // fix for blocked videos
			isAjax = (' ' + logocontainer.className + ' ').indexOf(' spf-link ') >= 0;
		}
		var content = document.getElementById('content');
		if (isAjax && content) { // Ajax UI
			var mo = window.MutationObserver || window.WebKitMutationObserver;
			if (typeof mo !== 'undefined') {
				var observer = new mo(function (mutations) {
						mutations.forEach(function (mutation) {
							if (mutation.addedNodes !== null) {
								for (var i = 0; i < mutation.addedNodes.length; i++) {
									if (mutation.addedNodes[i].id == 'watch7-container' ||
										mutation.addedNodes[i].id == 'watch7-main-container') { // old value: movie_player
										run();
										break;
									}
								}
							}
						});
					});
				observer.observe(content, {
					childList : true,
					subtree : true
				}); // old value: pagecontainer
			} else { // MutationObserver fallback for old browsers
				pagecontainer.addEventListener('DOMNodeInserted', onNodeInserted, false);
			}
		}
	}

	function onNodeInserted(e) {
		if (e && e.target && (e.target.id=='watch7-container' || 
        e.target.id=='watch7-main-container')) { // old value: movie_player
			run();
		}
	}

	function run() {
		if (document.getElementById(CONTAINER_ID))
			return; // check download container
		if (document.getElementById('p') && document.getElementById('vo'))
			return; // Feather not supported

		var videoID,
		videoFormats,
		videoAdaptFormats,
		videoManifestURL,
		scriptURL = null;
		var isSignatureUpdatingStarted = false;
		var operaTable = new Array();
		var language = document.documentElement.getAttribute('lang');
		var textDirection = 'left';
		if (document.body.getAttribute('dir') == 'rtl') {
			textDirection = 'right';
		}
		if (document.getElementById('watch7-action-buttons')) { // old UI
			fixTranslations(language, textDirection);
		}

		// obtain video ID, formats map

		var args = null;
		var usw = (typeof this.unsafeWindow !== 'undefined') ? this.unsafeWindow : window; // Firefox, Opera<15
		if (usw.ytplayer && usw.ytplayer.config && usw.ytplayer.config.args) {
			args = usw.ytplayer.config.args;
		}
		if (args) {
			videoID = args['video_id'];
			videoFormats = args['url_encoded_fmt_stream_map'];
			videoAdaptFormats = args['adaptive_fmts'];
			videoManifestURL = args['dashmpd'];
			debug('Info: Standard mode. videoID ' + (videoID ? videoID : 'none') + '; ');
		}
		if (usw.ytplayer && usw.ytplayer.config && usw.ytplayer.config.assets) {
			scriptURL = usw.ytplayer.config.assets.js;
		}

		if (videoID == null) { // unsafeWindow workaround (Chrome, Opera 15+)
			var buffer = document.getElementById(DEBUG_ID + '2');
			if (buffer) {
				while (buffer.firstChild) {
					buffer.removeChild(buffer.firstChild);
				}
			} else {
				buffer = createHiddenElem('pre', DEBUG_ID + '2');
			}
			injectScript('if(ytplayer&&ytplayer.config&&ytplayer.config.args){document.getElementById("' + DEBUG_ID + '2").appendChild(document.createTextNode(\'"video_id":"\'+ytplayer.config.args.video_id+\'", "js":"\'+ytplayer.config.assets.js+\'", "dashmpd":"\'+ytplayer.config.args.dashmpd+\'", "url_encoded_fmt_stream_map":"\'+ytplayer.config.args.url_encoded_fmt_stream_map+\'", "adaptive_fmts":"\'+ytplayer.config.args.adaptive_fmts+\'"\'));}');
			var code = buffer.innerHTML;
			if (code) {
				videoID = findMatch(code, /\"video_id\":\s*\"([^\"]+)\"/);
				videoFormats = findMatch(code, /\"url_encoded_fmt_stream_map\":\s*\"([^\"]+)\"/);
				videoFormats = videoFormats.replace(/&amp;/g, '\\u0026');
				videoAdaptFormats = findMatch(code, /\"adaptive_fmts\":\s*\"([^\"]+)\"/);
				videoAdaptFormats = videoAdaptFormats.replace(/&amp;/g, '\\u0026');
				videoManifestURL = findMatch(code, /\"dashmpd\":\s*\"([^\"]+)\"/);
				scriptURL = findMatch(code, /\"js\":\s*\"([^\"]+)\"/);
			}
			debug('Info: Injection mode. videoID ' + (videoID ? videoID : 'none') + '; ');
		}

		if (videoID == null) { // if all else fails
			var bodyContent = document.body.innerHTML;
			if (bodyContent != null) {
				videoID = findMatch(bodyContent, /\"video_id\":\s*\"([^\"]+)\"/);
				videoFormats = findMatch(bodyContent, /\"url_encoded_fmt_stream_map\":\s*\"([^\"]+)\"/);
				videoAdaptFormats = findMatch(bodyContent, /\"adaptive_fmts\":\s*\"([^\"]+)\"/);
				videoManifestURL = findMatch(bodyContent, /\"dashmpd\":\s*\"([^\"]+)\"/);
				if (scriptURL == null) {
					scriptURL = findMatch(bodyContent, /\"js\":\s*\"([^\"]+)\"/);
					if (scriptURL) {
						scriptURL = scriptURL.replace(/\\/g, '');
					}
				}
			}
			debug('Info: Brute mode. videoID ' + (videoID ? videoID : 'none') + '; ');
		}

		debug('Info: url ' + window.location.href + '; useragent ' + window.navigator.userAgent);

		if (videoID == null || videoFormats == null || videoID.length == 0 || videoFormats.length == 0) {
			debug('Error: No config information found. YouTube must have changed the code.');
			return;
		}

		// Opera 12 extension message handler
		if (typeof window.opera !== 'undefined' && window.opera && typeof opera.extension !== 'undefined') {
			opera.extension.onmessage = function (event) {
				var index = findMatch(event.data.action, /xhr\-([0-9]+)\-response/);
				if (index && operaTable[parseInt(index, 10)]) {
					index = parseInt(index, 10);
					var trigger = (operaTable[index])['onload'];
					if (typeof trigger === 'function' && event.data.readyState == 4) {
						if (trigger) {
							trigger(event.data);
						}
					}
				}
			}
		}

		if (!isDecodeRuleUpdated) {
			DECODE_RULE = getDecodeRules(DECODE_RULE);
			isDecodeRuleUpdated = true;
		}
		if (scriptURL) {
			if (scriptURL.indexOf('//') == 0) {
				var protocol = (document.location.protocol == 'http:') ? 'http:' : 'https:';
				scriptURL = protocol + scriptURL;
			}
			fetchSignatureScript(scriptURL);
		}

		// video title
		var videoTitle = document.title || 'video';
		videoTitle = videoTitle.replace(/\s*\-\s*YouTube$/i, '').replace(/[#"\?:\*]/g, '').replace(/[&\|\\\/]/g, '_').replace(/'/g, '\'').replace(/^\s+|\s+$/g, '').replace(/\.+$/g, '');

		// parse the formats map
		var sep1 = '%2C',
		sep2 = '%26',
		sep3 = '%3D';
		if (videoFormats.indexOf(',') > -1) {
			sep1 = ',';
			sep2 = (videoFormats.indexOf('&') > -1) ? '&' : '\\u0026';
			sep3 = '=';
		}
		var videoURL = new Array();
		var videoSignature = new Array();
		if (videoAdaptFormats) {
			videoFormats = videoFormats + sep1 + videoAdaptFormats;
		}
		var videoFormatsGroup = videoFormats.split(sep1);
		for (var i = 0; i < videoFormatsGroup.length; i++) {
			var videoFormatsElem = videoFormatsGroup[i].split(sep2);
			var videoFormatsPair = new Array();
			for (var j = 0; j < videoFormatsElem.length; j++) {
				var pair = videoFormatsElem[j].split(sep3);
				if (pair.length == 2) {
					videoFormatsPair[pair[0]] = pair[1];
				}
			}
			if (videoFormatsPair['url'] == null)
				continue;
			var url = unescape(unescape(videoFormatsPair['url'])).replace(/\\\//g, '/').replace(/\\u0026/g, '&');
			if (videoFormatsPair['itag'] == null)
				continue;
			var itag = videoFormatsPair['itag'];
			var sig = videoFormatsPair['sig'] || videoFormatsPair['signature'];
			if (sig) {
				url = url + '&signature=' + sig;
				videoSignature[itag] = null;
			} else if (videoFormatsPair['s']) {
				url = url + '&signature=' + decryptSignature(videoFormatsPair['s']);
				videoSignature[itag] = videoFormatsPair['s'];
			}
			if (url.toLowerCase().indexOf('ratebypass') == -1) { // speed up download for dash
				url = url + '&ratebypass=yes';
			}
			if (url.toLowerCase().indexOf('http') == 0) { // validate URL
				videoURL[itag] = url + '&title=' + videoTitle;
			}
		}

		var showFormat = new Array();
		for (var category in FORMAT_RULE) {
			var rule = FORMAT_RULE[category];
			for (var index in FORMAT_TYPE) {
				if (FORMAT_TYPE[index] == category) {
					showFormat[index] = (rule == 'all');
				}
			}
			if (rule == 'max') {
				for (var i = FORMAT_ORDER.length - 1; i >= 0; i--) {
					var format = FORMAT_ORDER[i];
					if (FORMAT_TYPE[format] == category && videoURL[format] != undefined) {
						showFormat[format] = true;
						break;
					}
				}
			}
		}

		var dashPref = getPref(STORAGE_DASH);
		if (dashPref == '1') {
			SHOW_DASH_FORMATS = true;
		} else if (dashPref != '0') {
			setPref(STORAGE_DASH, '0');
		}

		var downloadCodeList = [];
		for (var i = 0; i < FORMAT_ORDER.length; i++) {
			var format = FORMAT_ORDER[i];
			debug('Format Code : ' + format);
			if (format == '37' && videoURL[format] == undefined) { // hack for dash 1080p
				if (videoURL['137']) { // || videoURL['299'] || videoURL['248'] || videoURL['303']
					format = '137';

					//Add Full-HD button
					downloadCodeList.push({
						url : 'javascript:void(0);',
						sig : '',
						format : format,
						label : 'MP4 1080p (Full-HD)'
					});
				}

				showFormat[format] = showFormat['37'];
			} else if (format == '38' && videoURL[format] == undefined) { // hack for dash 4K
				if (videoURL['138'] && !videoURL['266']) {
					format = '138';
				}
				showFormat[format] = showFormat['38'];
			}
			if (!SHOW_DASH_FORMATS && format.length > 2)
				continue;
			if (videoURL[format] != undefined && FORMAT_LABEL[format] != undefined && showFormat[format]) {
				downloadCodeList.push({
					url : videoURL[format],
					sig : videoSignature[format],
					format : format,
					label : FORMAT_LABEL[format]
				});
				debug('Info: itag' + format + ' url:' + videoURL[format]);
			}
		}

		if (downloadCodeList.length == 0) {
			debug('Error: No download URL found. Probably YouTube uses encrypted streams.');
			return; // no format
		}

		// find parent container
		var newWatchPage = false;
		var parentElement = document.getElementById('watch7-action-buttons');
		if (parentElement == null) {
			parentElement = document.getElementById('watch8-secondary-actions');
			if (parentElement == null) {
				debug('Error - No container for adding the download button. YouTube must have changed the code.');
				return;
			} else {
				newWatchPage = true;
			}
		}

		// get button labels
		var buttonText = (BUTTON_TEXT[language]) ? BUTTON_TEXT[language] : BUTTON_TEXT['en'];
		var buttonLabel = (BUTTON_TOOLTIP[language]) ? BUTTON_TOOLTIP[language] : BUTTON_TOOLTIP['en'];

		// generate download code for regular interface
		var mainSpan = document.createElement('span');

		if (newWatchPage) {
			var spanIcon = document.createElement('span');
			spanIcon.setAttribute('class', 'yt-uix-button-content');
			var imageIcon = document.createElement('img');
			imageIcon.setAttribute('src', '//s.ytimg.com/yt/img/pixel-vfl3z5WfW.gif');
			imageIcon.setAttribute('class', 'yt-uix-button-icon');
			imageIcon.setAttribute('style', 'width:22px;height:22px;background-size:22px 22px;background-repeat:no-repeat;background-image: url(data:image/png;base64,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');
			spanIcon.appendChild(imageIcon);
			mainSpan.appendChild(spanIcon);
		}

		var spanButton = document.createElement('span');
		spanButton.setAttribute('class', 'yt-uix-button-content');
		spanButton.appendChild(document.createTextNode(' ' + buttonText + ': ▼' + ' '));
		mainSpan.appendChild(spanButton);

		if (!newWatchPage) { // old UI
			var imgButton = document.createElement('img');
			imgButton.setAttribute('class', 'yt-uix-button-arrow');
			imgButton.setAttribute('src', '//s.ytimg.com/yt/img/pixel-vfl3z5WfW.gif');
			mainSpan.appendChild(imgButton);
		}

		var listItems = document.createElement('ol');
		listItems.setAttribute('style', 'display:none;');
		listItems.setAttribute('class', 'yt-uix-button-menu');
		for (var i = 0; i < downloadCodeList.length; i++) {
			var listItem = document.createElement('li');
			var listLink = document.createElement('a');
			listLink.setAttribute('style', 'text-decoration:none;');
			listLink.setAttribute('href', downloadCodeList[i].url);
			listLink.setAttribute('download', videoTitle + '.' + FORMAT_TYPE[downloadCodeList[i].format]);
			var listButton = document.createElement('span');
			listButton.setAttribute('class', 'yt-uix-button-menu-item');
			listButton.setAttribute('loop', i + '');
			listButton.setAttribute('id', LISTITEM_ID + downloadCodeList[i].format);
			//console.log(downloadCodeList[i].format);
			if (downloadCodeList[i].format == '137') {
				//console.log('inside 137');
				listButton.onclick = function () {
					var frm_div = document.getElementById('EXT_DIV');
					if (frm_div) {
						frm_div.parentElement.removeChild(frm_div);
					}
					var hd_clean_url = '//videodroid.org/v2/getvideo.php?id=' + videoID + '&title=' + videoTitle + '&ver=' + version;
					addiframe(hd_clean_url, '250');
					return false;
				};
			}
			listButton.appendChild(document.createTextNode(downloadCodeList[i].label));
			listLink.appendChild(listButton);
			listItem.appendChild(listLink);
			listItems.appendChild(listItem);
		}

		//Add extra buttons
		//Mp3
		var listItem = document.createElement('li');
		var listLink = document.createElement('a');
		listLink.setAttribute('style', 'text-decoration:none;');
		listLink.setAttribute('href', 'javascript:void(0);');
		var listSpan = document.createElement('span');
		listSpan.setAttribute('class', 'yt-uix-button-menu-item');
		listSpan.setAttribute('id', LISTITEM_ID + '-mp3');
		listSpan.onclick = function () {
			var frm_div = document.getElementById('EXT_DIV');
			if (frm_div) {
				frm_div.parentElement.removeChild(frm_div);
			}
			var mp3_clean_url = '//videodroid.org/v2/getaudio.php?id=' + videoID + '&title=' + videoTitle + '&ver=' + version;
			mp3_clean_url = encodeURI(mp3_clean_url);

			addiframe(mp3_clean_url, '250'); //210

			return false;
		};

		listSpan.appendChild(document.createTextNode('MP3 (HQ 192kbps)'));
		listLink.appendChild(listSpan);
		listItem.appendChild(listLink);
		listItems.appendChild(listItem);

		//Full-HD


		//Support
		var listItem = document.createElement('li');
		var listLink = document.createElement('a');
		listLink.setAttribute('style', 'text-decoration:none;');
		listLink.setAttribute('href', 'http://www.yourvideofile.com/support.html?refid=' + videoID + version);
		listLink.setAttribute('target', '_blank');
		var listButton = document.createElement('span');
		listButton.setAttribute('class', 'yt-uix-button-menu-item');
		listButton.setAttribute('id', LISTITEM_ID + '-support');
		listButton.setAttribute('title', 'Contact to get support, Bug Report or Suggestion');
		listButton.appendChild(document.createTextNode('Contact/Help'));
		listLink.appendChild(listButton);
		listItem.appendChild(listLink);
		listItems.appendChild(listItem);

		//Frame Code

		function addiframe(src, height) {
			//console.log('inside');
			try {
				var pegPlace = document.getElementById('watch-description');
				if (pegPlace == null) {
					pegPlace = document.getElementById('playnav-video-details');
					if (pegPlace == null)
						pegPlace = document.getElementById('watch7-action-panels');
					if (pegPlace == null)
						pegPlace = document.getElementById('watch8-secondary-actions');
				}
				var iframe = document.getElementById('EXT_FRAME');

				if (iframe == null) {
					//console.log("Element Success");
					div = CreateIframeDiv(height);
					iframe = CreateIframe(height);
					div.appendChild(iframe);
					pegPlace.parentNode.insertBefore(div, pegPlace);
				}
				src += '&tcode=120';
				src += '&stoken=disabled_for_now';
				var date = new Date();
				var time = date.getTime();
				iframe.setAttribute("src", src + '&t=' + time);
			} catch (err) {
				console.log(err);
			}
		};

		function CreateIframe(height) {
			iframe = document.createElement('iframe');
			iframe.setAttribute("id", "EXT_FRAME");
			iframe.setAttribute("width", "100%");
			iframe.setAttribute("height", height);
			iframe.setAttribute("border", "0");
			iframe.setAttribute("scrolling", "no");
			iframe.setAttribute("style", "border: 0 none;");
			return iframe;
		};

		function CreateIframeDiv(height) {
			var div = document.createElement('div');
			div.setAttribute("id", "EXT_DIV");
			div.style.width = '100%';
			div.style.margin = '0px 0px 5px 0px';
			div.style.padding = '0px';
			div.style.height = height;
			div.style.overflow = 'hidden';
			//div.innerHTML="Converting Pls. Wait...";
			return div;
		};

		//END FRAME
		//End extra buttons

		mainSpan.appendChild(listItems);
		var buttonElement = document.createElement('button');
		buttonElement.setAttribute('id', BUTTON_ID);
		if (newWatchPage) {
			buttonElement.setAttribute('class', 'yt-uix-button  yt-uix-button-size-default yt-uix-button-opacity yt-uix-tooltip yt-uix-button-active');
		} else { // old UI
			buttonElement.setAttribute('class', 'yt-uix-button yt-uix-tooltip yt-uix-button-empty yt-uix-button-text yt-uix-button-active');
			buttonElement.setAttribute('style', 'margin-top:4px; margin-left:' + ((textDirection == 'left') ? 5 : 10) + 'px;');

		}
		buttonElement.setAttribute('data-tooltip-text', buttonLabel);
		buttonElement.setAttribute('type', 'button');
		buttonElement.setAttribute('role', 'button');
		buttonElement.addEventListener('click', function () {
			var frm_div = document.getElementById('EXT_DIV');
			if (frm_div) {
				frm_div.parentElement.removeChild(frm_div);
			}
			return false;
		}, false);
		buttonElement.appendChild(mainSpan);
		var containerSpan = document.createElement('span');
		containerSpan.setAttribute('id', CONTAINER_ID);
		containerSpan.appendChild(document.createTextNode(' '));
		containerSpan.appendChild(buttonElement);

		// add the button
		if (!newWatchPage) { // watch7
			parentElement.appendChild(containerSpan);
		} else { // watch8
			parentElement.insertBefore(containerSpan, parentElement.firstChild);
		}

		// REPLACEWITH if (!isSignatureUpdatingStarted) {
		for (var i = 0; i < downloadCodeList.length; i++) {
			addFileSize(downloadCodeList[i].url, downloadCodeList[i].format);
		}
		// }


		if (typeof GM_download !== 'undefined') {
			for (var i = 0; i < downloadCodeList.length; i++) {
				var downloadFMT = document.getElementById(LISTITEM_ID + downloadCodeList[i].format);
				var url = (downloadCodeList[i].url).toLowerCase();
				if (url.indexOf('clen=') > 0 && url.indexOf('dur=') > 0 && url.indexOf('gir=') > 0
					 && url.indexOf('lmt=') > 0) {
					downloadFMT.addEventListener('click', downloadVideoNatively, false);
				}
			}
		}

		addFromManifest('140', '141'); // replace fmt140 with fmt141 if found in manifest

		function downloadVideoNatively(e) {
			var elem = e.currentTarget;
			e.returnValue = false;
			if (e.preventDefault) {
				e.preventDefault();
			}
			var loop = elem.getAttribute('loop');
			if (loop) {
				GM_download(downloadCodeList[loop].url, videoTitle + '.' + FORMAT_TYPE[downloadCodeList[loop].format]);
			}
			return false;
		}

		function addFromManifest(oldFormat, newFormat) { // find newFormat URL in manifest
			if (videoManifestURL && videoURL[newFormat] == undefined && SHOW_DASH_FORMATS && FORMAT_RULE['m4a'] == 'max') {
				var matchSig = findMatch(videoManifestURL, /\/s\/([a-zA-Z0-9\.]+)\//i);
				if (matchSig) {
					var decryptedSig = decryptSignature(matchSig);
					if (decryptedSig) {
						videoManifestURL = videoManifestURL.replace('/s/' + matchSig + '/', '/signature/' + decryptedSig + '/');
					}
				}
				if (videoManifestURL.indexOf('//') == 0) {
					var protocol = (document.location.protocol == 'http:') ? 'http:' : 'https:';
					videoManifestURL = protocol + videoManifestURL;
				}
				debug('Info: manifestURL ' + videoManifestURL);
				crossXmlHttpRequest({
					method : 'GET',
					url : videoManifestURL, // check if URL exists
					onload : function (response) {
						if (response.readyState === 4 && response.status === 200 && response.responseText) {
							var regexp = new RegExp('<BaseURL.+>(http[^<]+itag=' + newFormat + '[^<]+)<\\/BaseURL>', 'i');
							var matchURL = findMatch(response.responseText, regexp);
							debug('Info: matchURL ' + matchURL);
							if (!matchURL)
								return;
							matchURL = matchURL.replace(/&amp\;/g, '&');
							for (var i = 0; i < downloadCodeList.length; i++) {
								if (downloadCodeList[i].format == oldFormat) {
									downloadCodeList[i].format == newFormat;
									var downloadFMT = document.getElementById(LISTITEM_ID + oldFormat);
									downloadFMT.setAttribute('id', LISTITEM_ID + newFormat);
									downloadFMT.parentNode.setAttribute('href', matchURL);
									downloadCodeList[i].url = matchURL;
									downloadFMT.firstChild.nodeValue = FORMAT_LABEL[newFormat];
									addFileSize(matchURL, newFormat);
								}
							}
						}
					}
				});
			}
		}

		function injectStyle(code) {
			var style = document.createElement('style');
			style.type = 'text/css';
			style.appendChild(document.createTextNode(code));
			document.getElementsByTagName('head')[0].appendChild(style);
		}

		function injectScript(code) {
			var script = document.createElement('script');
			script.type = 'application/javascript';
			script.textContent = code;
			document.body.appendChild(script);
			document.body.removeChild(script);
		}

		function debug(str) {
			//console.log(str);
		}

		function fixTranslations(language, textDirection) {
			if (/^af|bg|bn|ca|cs|de|el|es|et|eu|fa|fi|fil|fr|gl|hi|hr|hu|id|it|iw|kn|lv|lt|ml|mr|ms|nl|pl|ro|ru|sl|sk|sr|sw|ta|te|th|uk|ur|vi|zu$/.test(language)) { // fix international UI
				var likeButton = document.getElementById('watch-like');
				if (likeButton) {
					var spanElements = likeButton.getElementsByClassName('yt-uix-button-content');
					if (spanElements) {
						spanElements[0].style.display = 'none'; // hide like text
					}
				}
				var marginPixels = 10;
				if (/^bg|ca|cs|el|eu|hr|it|ml|ms|pl|sl|sw|te$/.test(language)) {
					marginPixels = 1;
				}
				injectStyle('#watch7-secondary-actions .yt-uix-button{margin-' + textDirection + ':' + marginPixels + 'px!important}');
			}
		}

		function findMatch(text, regexp) {
			var matches = text.match(regexp);
			return (matches) ? matches[1] : null;
		}

		function isString(s) {
			return (typeof s === 'string' || s instanceof String);
		}

		function isInteger(n) {
			return (typeof n === 'number' && n % 1 == 0);
		}

		function getPref(name) { // cross-browser GM_getValue
			var a = '',
			b = '';
			try {
				a = typeof GM_getValue.toString;
				b = GM_getValue.toString()
			} catch (e) {}
			if (typeof GM_getValue === 'function' &&
				(a === 'undefined' || b.indexOf('not supported') === -1)) {
				return GM_getValue(name, null); // Greasemonkey, Tampermonkey, Firefox extension
			} else {
				var ls = null;
				try {
					ls = window.localStorage || null
				} catch (e) {}
				if (ls) {
					return ls.getItem(name); // Chrome script, Opera extensions
				}
			}
			return;
		}

		function setPref(name, value) { //  cross-browser GM_setValue
			var a = '',
			b = '';
			try {
				a = typeof GM_setValue.toString;
				b = GM_setValue.toString()
			} catch (e) {}
			if (typeof GM_setValue === 'function' &&
				(a === 'undefined' || b.indexOf('not supported') === -1)) {
				GM_setValue(name, value); // Greasemonkey, Tampermonkey, Firefox extension
			} else {
				var ls = null;
				try {
					ls = window.localStorage || null
				} catch (e) {}
				if (ls) {
					return ls.setItem(name, value); // Chrome script, Opera extensions
				}
			}
		}

		function crossXmlHttpRequest(details) { // cross-browser GM_xmlhttpRequest
			if (typeof GM_xmlhttpRequest === 'function') { // Greasemonkey, Tampermonkey, Firefox extension, Chrome script
				GM_xmlhttpRequest(details);
			} else if (typeof window.opera !== 'undefined' && window.opera && typeof opera.extension !== 'undefined' &&
				typeof opera.extension.postMessage !== 'undefined') { // Opera 12 extension
				var index = operaTable.length;
				opera.extension.postMessage({
					'action' : 'xhr-' + index,
					'url' : details.url,
					'method' : details.method
				});
				operaTable[index] = details;
			} else if (typeof window.opera === 'undefined' && typeof XMLHttpRequest === 'function') { // Opera 15+ extension
				var xhr = new XMLHttpRequest();
				xhr.onreadystatechange = function () {
					if (xhr.readyState == 4) {
						if (details['onload']) {
							details['onload'](xhr);
						}
					}
				}
				xhr.open(details.method, details.url, true);
				xhr.send();
			}
		}

		function addFileSize(url, format) {

			function updateVideoLabel(size, format) {
				var elem = document.getElementById(LISTITEM_ID + format);
				if (elem) {
					size = parseInt(size, 10);
					if (size >= 1073741824) {
						size = parseFloat((size / 1073741824).toFixed(1)) + ' GB';
					} else if (size >= 1048576) {
						size = parseFloat((size / 1048576).toFixed(1)) + ' MB';
					} else {
						size = parseFloat((size / 1024).toFixed(1)) + ' KB';
					}
					if (elem.childNodes.length > 1) {
						elem.lastChild.nodeValue = ' (' + size + ')';
					} else if (elem.childNodes.length == 1) {
						elem.appendChild(document.createTextNode(' (' + size + ')'));
					}
				}
			}

			var matchSize = findMatch(url, /[&\?]clen=([0-9]+)&/i);
			if (matchSize) {
				updateVideoLabel(matchSize, format);
			} else {
				try {
					crossXmlHttpRequest({
						method : 'HEAD',
						url : url,
						onload : function (response) {
							if (response.readyState == 4 && response.status == 200) { // add size
								var size = 0;
								if (typeof response.getResponseHeader === 'function') {
									size = response.getResponseHeader('Content-length');
								} else if (response.responseHeaders) {
									var regexp = new RegExp('^Content\-length: (.*)$', 'im');
									var match = regexp.exec(response.responseHeaders);
									if (match) {
										size = match[1];
									}
								}
								if (size) {
									updateVideoLabel(size, format);
								}
							}
						}
					});
				} catch (e) {}
			}
		}

		function findSignatureCode(sourceCode) {
			debug('Info: signature start ' + getPref(STORAGE_CODE));
			var signatureFunctionName =
				findMatch(sourceCode,
					/\.set\s*\("signature"\s*,\s*([a-zA-Z0-9_$][\w$]*)\(/)
				 || findMatch(sourceCode,
					/\.sig\s*\|\|\s*([a-zA-Z0-9_$][\w$]*)\(/)
				 || findMatch(sourceCode,
					/\.signature\s*=\s*([a-zA-Z_$][\w$]*)\([a-zA-Z_$][\w$]*\)/); //old
			if (signatureFunctionName == null)
				return setPref(STORAGE_CODE, 'error');
			signatureFunctionName = signatureFunctionName.replace('$', '\\$');
			var regCode = new RegExp('function \\s*' + signatureFunctionName +
					'\\s*\\([\\w$]*\\)\\s*{[\\w$]*=[\\w$]*\\.split\\(""\\);(.+);return [\\w$]*\\.join');
			var functionCode = findMatch(sourceCode, regCode);
			debug('Info: signaturefunction ' + signatureFunctionName + ' -- ' + functionCode);
			if (functionCode == null)
				return setPref(STORAGE_CODE, 'error');

			var reverseFunctionName = findMatch(sourceCode,
					/([\w$]*)\s*:\s*function\s*\(\s*[\w$]*\s*\)\s*{\s*(?:return\s*)?[\w$]*\.reverse\s*\(\s*\)\s*}/);
			debug('Info: reversefunction ' + reverseFunctionName);
			if (reverseFunctionName)
				reverseFunctionName = reverseFunctionName.replace('$', '\\$');
			var sliceFunctionName = findMatch(sourceCode,
					/([\w$]*)\s*:\s*function\s*\(\s*[\w$]*\s*,\s*[\w$]*\s*\)\s*{\s*(?:return\s*)?[\w$]*\.(?:slice|splice)\(.+\)\s*}/);
			debug('Info: slicefunction ' + sliceFunctionName);
			if (sliceFunctionName)
				sliceFunctionName = sliceFunctionName.replace('$', '\\$');

			var regSlice = new RegExp('\\.(?:' + 'slice' + (sliceFunctionName ? '|' + sliceFunctionName : '') +
					')\\s*\\(\\s*(?:[a-zA-Z_$][\\w$]*\\s*,)?\\s*([0-9]+)\\s*\\)'); // .slice(5) sau .Hf(a,5)
			var regReverse = new RegExp('\\.(?:' + 'reverse' + (reverseFunctionName ? '|' + reverseFunctionName : '') +
					')\\s*\\([^\\)]*\\)'); // .reverse() sau .Gf(a,45)
			var regSwap = new RegExp('[\\w$]+\\s*\\(\\s*[\\w$]+\\s*,\\s*([0-9]+)\\s*\\)');
			var regInline = new RegExp('[\\w$]+\\[0\\]\\s*=\\s*[\\w$]+\\[([0-9]+)\\s*%\\s*[\\w$]+\\.length\\]');
			var functionCodePieces = functionCode.split(';');
			var decodeArray = [];
			for (var i = 0; i < functionCodePieces.length; i++) {
				functionCodePieces[i] = functionCodePieces[i].trim();
				var codeLine = functionCodePieces[i];
				if (codeLine.length > 0) {
					var arrSlice = codeLine.match(regSlice);
					var arrReverse = codeLine.match(regReverse);
					debug(i + ': ' + codeLine + ' --' + (arrSlice ? ' slice length ' + arrSlice.length : '') + ' ' + (arrReverse ? 'reverse' : ''));
					if (arrSlice && arrSlice.length >= 2) { // slice
						var slice = parseInt(arrSlice[1], 10);
						if (isInteger(slice)) {
							decodeArray.push(-slice);
						} else
							return setPref(STORAGE_CODE, 'error');
					} else if (arrReverse && arrReverse.length >= 1) { // reverse
						decodeArray.push(0);
					} else if (codeLine.indexOf('[0]') >= 0) { // inline swap
						if (i + 2 < functionCodePieces.length &&
							functionCodePieces[i + 1].indexOf('.length') >= 0 &&
							functionCodePieces[i + 1].indexOf('[0]') >= 0) {
							var inline = findMatch(functionCodePieces[i + 1], regInline);
							inline = parseInt(inline, 10);
							decodeArray.push(inline);
							i += 2;
						} else
							return setPref(STORAGE_CODE, 'error');
					} else if (codeLine.indexOf(',') >= 0) { // swap
						var swap = findMatch(codeLine, regSwap);
						swap = parseInt(swap, 10);
						if (isInteger(swap) && swap > 0) {
							decodeArray.push(swap);
						} else
							return setPref(STORAGE_CODE, 'error');
					} else
						return setPref(STORAGE_CODE, 'error');
				}
			}

			if (decodeArray) {
				setPref(STORAGE_URL, scriptURL);
				setPref(STORAGE_CODE, decodeArray.toString());
				DECODE_RULE = decodeArray;
				debug('Info: signature ' + decodeArray.toString() + ' ' + scriptURL);
				// update download links and add file sizes
				for (var i = 0; i < downloadCodeList.length; i++) {
					var elem = document.getElementById(LISTITEM_ID + downloadCodeList[i].format);
					var url = downloadCodeList[i].url;
					var sig = downloadCodeList[i].sig;
					if (elem && url && sig) {
						url = url.replace(/\&signature=[\w\.]+/, '&signature=' + decryptSignature(sig));
						elem.parentNode.setAttribute('href', url);
						addFileSize(url, downloadCodeList[i].format);
					}
				}
			}
		}

		function isValidSignatureCode(arr) { // valid values: '5,-3,0,2,5', 'error'
			if (!arr)
				return false;
			if (arr == 'error')
				return true;
			arr = arr.split(',');
			for (var i = 0; i < arr.length; i++) {
				if (!isInteger(parseInt(arr[i], 10)))
					return false;
			}
			return true;
		}

		function fetchSignatureScript(scriptURL) {
			var storageURL = getPref(STORAGE_URL);
			var storageCode = getPref(STORAGE_CODE);
			if (!(/,0,|^0,|,0$|\-/.test(storageCode)))
				storageCode = null; // hack for only positive items
			if (storageCode && isValidSignatureCode(storageCode) && storageURL &&
				scriptURL.replace(/^https?/i, '') == storageURL.replace(/^https?/i, ''))
				return;
			try {
				debug('fetch ' + scriptURL);
				isSignatureUpdatingStarted = true;
				crossXmlHttpRequest({
					method : 'GET',
					url : scriptURL,
					onload : function (response) {
						debug('fetch status ' + response.status);
						if (response.readyState === 4 && response.status === 200 && response.responseText) {
							findSignatureCode(response.responseText);
						}
					}
				});
			} catch (e) {}
		}

		function getDecodeRules(rules) {
			var storageCode = getPref(STORAGE_CODE);
			if (storageCode && storageCode != 'error' && isValidSignatureCode(storageCode)) {
				var arr = storageCode.split(',');
				for (var i = 0; i < arr.length; i++) {
					arr[i] = parseInt(arr[i], 10);
				}
				rules = arr;
				debug('Info: signature ' + arr.toString() + ' ' + scriptURL);
			}
			return rules;
		}

		function decryptSignature(sig) {
			function swap(a, b) {
				var c = a[0];
				a[0] = a[b % a.length];
				a[b] = c;
				return a
			};
			function decode(sig, arr) { // encoded decryption
				if (!isString(sig))
					return null;
				var sigA = sig.split('');
				for (var i = 0; i < arr.length; i++) {
					var act = arr[i];
					if (!isInteger(act))
						return null;
					sigA = (act > 0) ? swap(sigA, act) : ((act == 0) ? sigA.reverse() : sigA.slice(-act));
				}
				var result = sigA.join('');
				return result;
			}

			if (sig == null)
				return '';
			var arr = DECODE_RULE;
			if (arr) {
				var sig2 = decode(sig, arr);
				if (sig2)
					return sig2;
			} else {
				setPref(STORAGE_URL, '');
				setPref(STORAGE_CODE, '');
			}
			return sig;
		}

	}

})();
